/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.util;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.translate.SingleValueContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Fold
implements Serializable {
    public static <T> @UnknownKeyFor @NonNull @Initialized CombinableReduceFunction<T> of(@UnknownKeyFor @NonNull @Initialized BinaryFunction<T, T, T> fold) {
        return s -> s.reduce(fold::apply).orElseThrow(() -> new IllegalStateException("Received empty stream on input!"));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CombinableReduceFunction<T> of(T identity, @UnknownKeyFor @NonNull @Initialized BinaryFunction<T, T, T> fold) {
        return s -> s.reduce(identity, fold::apply);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ReduceFunctor<T, T> of(T identity, @UnknownKeyFor @NonNull @Initialized BinaryFunctor<T, T, T> fold) {
        return (s, ctx) -> {
            SingleValueContext wrap = new SingleValueContext(ctx.asContext());
            Object ret = s.reduce(identity, (a, b) -> {
                fold.apply(a, b, wrap);
                return wrap.getAndResetValue();
            });
            ctx.collect(ret);
        };
    }
}

