/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

class WindowBuilder<@UnknownKeyFor T>
implements Builders.WindowBy<WindowBuilder<T>>,
Builders.TriggeredBy<WindowBuilder<T>>,
Builders.AccumulationMode<WindowBuilder<T>>,
Builders.WindowedOutput<WindowBuilder<T>> {
    private @Nullable @UnknownKeyFor @Initialized Window<T> window;

    WindowBuilder() {
    }

    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Window<T>> getWindow() {
        return Optional.ofNullable(this.window);
    }

    void setWindow(@UnknownKeyFor @NonNull @Initialized Window<T> window) {
        Preconditions.checkState((this.window == null ? 1 : 0) != 0, (Object)"Window is already set.");
        this.window = window;
    }

    @Override
    public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized WindowBuilder<T> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> windowFn) {
        Preconditions.checkState((this.window == null ? 1 : 0) != 0, (Object)"Window is already set.");
        this.window = Window.into(windowFn);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowBuilder<T> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
        this.window = Objects.requireNonNull(this.window).triggering(trigger);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowBuilder<T> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode accumulationMode) {
        switch (Objects.requireNonNull(accumulationMode)) {
            case DISCARDING_FIRED_PANES: {
                this.window = Objects.requireNonNull(this.window).discardingFiredPanes();
                break;
            }
            case ACCUMULATING_FIRED_PANES: {
                this.window = Objects.requireNonNull(this.window).accumulatingFiredPanes();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown accumulation mode [" + accumulationMode + "]");
            }
        }
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowBuilder<T> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
        this.window = Objects.requireNonNull(this.window).withAllowedLateness(Objects.requireNonNull(allowedLateness));
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowBuilder<T> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior) {
        this.window = Objects.requireNonNull(this.window).withAllowedLateness(Objects.requireNonNull(allowedLateness), Objects.requireNonNull(closingBehavior));
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowBuilder<T> withTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
        this.window = Objects.requireNonNull(this.window).withTimestampCombiner(Objects.requireNonNull(timestampCombiner));
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowBuilder<T> withOnTimeBehavior(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior behavior) {
        this.window = Objects.requireNonNull(this.window).withOnTimeBehavior(Objects.requireNonNull(behavior));
        return this;
    }
}

