/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.MapElements;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeUtils;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.Triple;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Derived(state=StateComplexity.CONSTANT, repartitions=1)
public class TopPerKey<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor ScoreT extends @UnknownKeyFor @NonNull @Initialized Comparable<ScoreT>>
extends ShuffleOperator<InputT, KeyT, Triple<KeyT, ValueT, ScoreT>>
implements TypeAware.Value<ValueT>,
CompositeOperator<InputT, Triple<KeyT, ValueT, ScoreT>> {
    private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor;
    private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType;
    private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ScoreT> scoreExtractor;
    private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ScoreT> scoreType;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return TopPerKey.named(null).of((PCollection)input);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name);
    }

    private TopPerKey(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ScoreT> scoreExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ScoreT> scoreType, @Nullable @UnknownKeyFor @Initialized Window<InputT> window, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Triple<KeyT, ValueT, ScoreT>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
        this.valueExtractor = valueExtractor;
        this.valueType = valueType;
        this.scoreExtractor = scoreExtractor;
        this.scoreType = scoreType;
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> getValueExtractor() {
        return this.valueExtractor;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<ValueT>> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ScoreT> getScoreExtractor() {
        return this.scoreExtractor;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<ScoreT>> getScoreType() {
        return Optional.ofNullable(this.scoreType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Triple<KeyT, ValueT, ScoreT>> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        PCollection<Triple> extracted = MapElements.named("extract-key-value-score").of((PCollection)PCollectionLists.getOnlyElement(inputs)).using(elem -> Triple.of(this.getKeyExtractor().apply(elem), this.getValueExtractor().apply(elem), (Comparable)this.getScoreExtractor().apply(elem)), (TypeDescriptor)this.getOutputType().orElse(null)).output();
        return ReduceByKey.named("combine-by-key").of((PCollection)extracted).keyBy(Triple::getFirst, (TypeDescriptor)this.getKeyType().orElse(null)).combineBy(triplets -> (Triple)triplets.reduce((a, b) -> ((Comparable)a.getThird()).compareTo((Comparable)b.getThird()) > 0 ? a : b).orElseThrow(IllegalStateException::new)).applyIf(this.getWindow().isPresent(), builder -> {
            ReduceByKey.WindowByInternalBuilder cast = (ReduceByKey.WindowByInternalBuilder)((Object)builder);
            return cast.windowBy(this.getWindow().orElseThrow(() -> new IllegalStateException("Unable to resolve windowing for TopPerKey expansion.")));
        }).outputValues();
    }

    private static class Builder<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor ScoreT extends @UnknownKeyFor @NonNull @Initialized Comparable<ScoreT>>
    implements OfBuilder,
    KeyByBuilder<InputT>,
    ValueByBuilder<InputT, KeyT>,
    ScoreBy<InputT, KeyT, ValueT>,
    WindowByBuilder<KeyT, ValueT, ScoreT>,
    TriggeredByBuilder<KeyT, ValueT, ScoreT>,
    AccumulationModeBuilder<KeyT, ValueT, ScoreT>,
    WindowedOutputBuilder<KeyT, ValueT, ScoreT>,
    OutputBuilder<KeyT, ValueT, ScoreT> {
        private final @UnknownKeyFor @NonNull @Initialized WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ScoreT> scoreExtractor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ScoreT> scoreType;

        Builder(@Nullable @UnknownKeyFor @Initialized String name) {
            this.name = name;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<T> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            this.input = Objects.requireNonNull(input);
            return this;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized ValueByBuilder<InputT, T> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> keyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> keyType) {
            Builder cast = this;
            cast.keyExtractor = Objects.requireNonNull(keyExtractor);
            cast.keyType = keyType;
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized ScoreBy<InputT, KeyT, T> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> valueExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> valueType) {
            Builder cast = this;
            cast.valueExtractor = Objects.requireNonNull(valueExtractor);
            cast.valueType = valueType;
            return cast;
        }

        @Override
        public <T extends Comparable<T>> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT, T> scoreBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> scoreExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> scoreType) {
            Builder cast = this;
            cast.scoreExtractor = Objects.requireNonNull(scoreExtractor);
            cast.scoreType = scoreType;
            return cast;
        }

        @Override
        public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<KeyT, ValueT, ScoreT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<KeyT, ValueT, ScoreT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, ValueT, ScoreT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, ValueT, ScoreT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, ValueT, ScoreT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, ValueT, ScoreT> withTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, ValueT, ScoreT> withOnTimeBehavior(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Triple<KeyT, ValueT, ScoreT>> output() {
            TopPerKey sbk = new TopPerKey(this.name, this.keyExtractor, this.keyType, this.valueExtractor, this.valueType, this.scoreExtractor, this.scoreType, this.windowBuilder.getWindow().orElse(null), TypeUtils.triplets(this.keyType, this.valueType, this.scoreType));
            return OperatorTransform.apply(sbk, PCollectionList.of(this.input));
        }
    }

    public static interface OutputBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor ScoreT extends @UnknownKeyFor @NonNull @Initialized Comparable<ScoreT>>
    extends Builders.Output<Triple<KeyT, ValueT, ScoreT>> {
    }

    public static interface WindowedOutputBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor ScoreT extends @UnknownKeyFor @NonNull @Initialized Comparable<ScoreT>>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT, ValueT, ScoreT>>,
    OutputBuilder<KeyT, ValueT, ScoreT> {
    }

    public static interface AccumulationModeBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor ScoreT extends @UnknownKeyFor @NonNull @Initialized Comparable<ScoreT>>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT, ValueT, ScoreT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, ValueT, ScoreT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor ScoreT extends @UnknownKeyFor @NonNull @Initialized Comparable<ScoreT>>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT, ValueT, ScoreT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<KeyT, ValueT, ScoreT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger var1);
    }

    public static interface WindowByBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor ScoreT extends @UnknownKeyFor @NonNull @Initialized Comparable<ScoreT>>
    extends Builders.WindowBy<TriggeredByBuilder<KeyT, ValueT, ScoreT>>,
    OptionalMethodBuilder<WindowByBuilder<KeyT, ValueT, ScoreT>, OutputBuilder<KeyT, ValueT, ScoreT>>,
    OutputBuilder<KeyT, ValueT, ScoreT> {
        @Override
        public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<KeyT, ValueT, ScoreT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> var1);

        @Override
        default public @UnknownKeyFor @NonNull @Initialized OutputBuilder<KeyT, ValueT, ScoreT> applyIf(@UnknownKeyFor @NonNull @Initialized boolean cond, @UnknownKeyFor @NonNull @Initialized UnaryFunction<@UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT, ScoreT>, @UnknownKeyFor @NonNull @Initialized OutputBuilder<KeyT, ValueT, ScoreT>> fn) {
            return cond ? Objects.requireNonNull(fn).apply(this) : this;
        }
    }

    public static interface ScoreBy<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor ValueT> {
        default public <ScoreT extends Comparable<ScoreT>> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT, ScoreT> scoreBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ScoreT> scoreFn) {
            return this.scoreBy(scoreFn, null);
        }

        public <ScoreT extends Comparable<ScoreT>> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT, ScoreT> scoreBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ScoreT> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ScoreT> var2);
    }

    public static interface ValueByBuilder<@UnknownKeyFor InputT, @UnknownKeyFor KeyT> {
        default public <ValueT> @UnknownKeyFor @NonNull @Initialized ScoreBy<InputT, KeyT, ValueT> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor) {
            return this.valueBy(valueExtractor, null);
        }

        public <ValueT> @UnknownKeyFor @NonNull @Initialized ScoreBy<InputT, KeyT, ValueT> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> var2);
    }

    public static interface KeyByBuilder<@UnknownKeyFor InputT>
    extends Builders.KeyBy<InputT> {
        public <T> @UnknownKeyFor @NonNull @Initialized ValueByBuilder<InputT, T> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> var1, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> var2);

        default public <T> @UnknownKeyFor @NonNull @Initialized ValueByBuilder<InputT, T> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> keyExtractor) {
            return this.keyBy((UnaryFunction)keyExtractor, (TypeDescriptor)null);
        }
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> var1);
    }
}

