/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeUtils;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.Sums;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Derived(state=StateComplexity.CONSTANT, repartitions=1)
public class SumByKey<@UnknownKeyFor InputT, @UnknownKeyFor KeyT>
extends ShuffleOperator<InputT, KeyT, KV<KeyT, Long>>
implements CompositeOperator<InputT, KV<KeyT, Long>> {
    private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> valueExtractor;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return SumByKey.named(null).of((PCollection)input);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name);
    }

    private SumByKey(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> valueExtractor, @Nullable @UnknownKeyFor @Initialized Window<InputT> window, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized Long>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
        this.valueExtractor = valueExtractor;
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> getValueExtractor() {
        return this.valueExtractor;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized Long>> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        return ReduceByKey.named(this.getName().orElse(null)).of((PCollection)PCollectionLists.getOnlyElement(inputs)).keyBy(this.getKeyExtractor()).valueBy(this.getValueExtractor(), TypeDescriptors.longs()).combineBy(Sums.ofLongs()).applyIf(this.getWindow().isPresent(), builder -> {
            ReduceByKey.WindowByInternalBuilder cast = (ReduceByKey.WindowByInternalBuilder)((Object)builder);
            return cast.windowBy(this.getWindow().orElseThrow(() -> new IllegalStateException("Unable to resolve windowing for SumByKey expansion.")));
        }).output();
    }

    private static class Builder<@UnknownKeyFor InputT, @UnknownKeyFor KeyT>
    implements OfBuilder,
    KeyByBuilder<InputT>,
    ValueByBuilder<InputT, KeyT>,
    WindowByBuilder<KeyT>,
    TriggeredByBuilder<KeyT>,
    AccumulationModeBuilder<KeyT>,
    WindowedOutputBuilder<KeyT>,
    Builders.Output<KV<KeyT, Long>> {
        private final @UnknownKeyFor @NonNull @Initialized WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> valueExtractor;

        Builder(@Nullable @UnknownKeyFor @Initialized String name) {
            this.name = name;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<T> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            this.input = Objects.requireNonNull(input);
            return this;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized ValueByBuilder<InputT, T> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> keyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> keyType) {
            Builder cast = this;
            cast.keyExtractor = Objects.requireNonNull(keyExtractor);
            cast.keyType = keyType;
            return cast;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> valueExtractor) {
            this.valueExtractor = Objects.requireNonNull(valueExtractor);
            return this;
        }

        @Override
        public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<KeyT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<KeyT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT> withTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT> withOnTimeBehavior(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized Long>> output() {
            if (this.valueExtractor == null) {
                this.valueExtractor = e -> 1L;
            }
            SumByKey sbk = new SumByKey(this.name, this.keyExtractor, this.keyType, this.valueExtractor, this.windowBuilder.getWindow().orElse(null), TypeUtils.keyValues(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeDescriptors.longs()));
            return OperatorTransform.apply(sbk, PCollectionList.of(this.input));
        }
    }

    public static interface WindowedOutputBuilder<@UnknownKeyFor KeyT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT>>,
    Builders.Output<KV<KeyT, Long>> {
    }

    public static interface AccumulationModeBuilder<@UnknownKeyFor KeyT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<@UnknownKeyFor KeyT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<KeyT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger var1);
    }

    public static interface WindowByBuilder<@UnknownKeyFor KeyT>
    extends Builders.WindowBy<TriggeredByBuilder<KeyT>>,
    OptionalMethodBuilder<WindowByBuilder<KeyT>, Builders.Output<KV<KeyT, Long>>>,
    Builders.Output<KV<KeyT, Long>> {
        @Override
        public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<KeyT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> var1);

        @Override
        default public  @UnknownKeyFor @NonNull @Initialized Builders.Output<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized Long>> applyIf(@UnknownKeyFor @NonNull @Initialized boolean cond, @UnknownKeyFor @NonNull @Initialized UnaryFunction<@UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT>,  @UnknownKeyFor @NonNull @Initialized Builders.Output<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized Long>>> fn) {
            return cond ? Objects.requireNonNull(fn).apply(this) : this;
        }
    }

    public static interface ValueByBuilder<@UnknownKeyFor InputT, @UnknownKeyFor KeyT>
    extends WindowByBuilder<KeyT> {
        public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> var1);
    }

    public static interface KeyByBuilder<@UnknownKeyFor InputT>
    extends Builders.KeyBy<InputT> {
        public <T> @UnknownKeyFor @NonNull @Initialized ValueByBuilder<InputT, T> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> var1, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> var2);

        default public <T> @UnknownKeyFor @NonNull @Initialized ValueByBuilder<InputT, T> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> keyExtractor) {
            return this.keyBy((UnaryFunction)keyExtractor, (TypeDescriptor)null);
        }
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> var1);
    }
}

