/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Collector;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Join;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RightJoin {
    public static <LeftT, RightT> @UnknownKeyFor @NonNull @Initialized ByBuilder<LeftT, RightT> of(@UnknownKeyFor @NonNull @Initialized PCollection<LeftT> left, @UnknownKeyFor @NonNull @Initialized PCollection<RightT> right) {
        return RightJoin.named("RightJoin").of(left, right);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@UnknownKeyFor @NonNull @Initialized String name) {
        return new Builder(name);
    }

    private static class Builder<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT>
    implements OfBuilder,
    ByBuilder<LeftT, RightT>,
    UsingBuilder<LeftT, RightT, KeyT> {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized PCollection<LeftT> left;
        private @UnknownKeyFor @NonNull @Initialized PCollection<RightT> right;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, KeyT> leftKeyExtractor;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, KeyT> rightKeyExtractor;
        @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType;

        private Builder(@UnknownKeyFor @NonNull @Initialized String name) {
            this.name = name;
        }

        public <FirstT, SecondT> @UnknownKeyFor @NonNull @Initialized ByBuilder<FirstT, SecondT> of(@UnknownKeyFor @NonNull @Initialized PCollection<FirstT> left, @UnknownKeyFor @NonNull @Initialized PCollection<SecondT> right) {
            Builder cast = this;
            cast.left = Objects.requireNonNull(left);
            cast.right = Objects.requireNonNull(right);
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized UsingBuilder<LeftT, RightT, T> by(@UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, T> leftKeyExtractor, @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, T> rightKeyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> keyType) {
            Builder cast = this;
            cast.leftKeyExtractor = Objects.requireNonNull(leftKeyExtractor);
            cast.rightKeyExtractor = Objects.requireNonNull(rightKeyExtractor);
            cast.keyType = keyType;
            return cast;
        }

        @Override
        public <OutputT>  @UnknownKeyFor @NonNull @Initialized Join.WindowByBuilder<KeyT, OutputT> using(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<@UnknownKeyFor @NonNull @Initialized Optional<LeftT>, RightT, OutputT> joinFunc, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType) {
            return new Join.Builder(this.name, Join.Type.RIGHT).of(this.left, this.right).by(this.leftKeyExtractor, this.rightKeyExtractor, this.keyType).using((LeftT l, RightT r, Collector<OutputT> c) -> joinFunc.apply(Optional.ofNullable(l), r, c), outputType);
        }
    }

    public static interface UsingBuilder<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT> {
        public <OutputT>  @UnknownKeyFor @NonNull @Initialized Join.WindowByBuilder<KeyT, OutputT> using(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<@UnknownKeyFor @NonNull @Initialized Optional<LeftT>, RightT, OutputT> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> var2);

        default public <OutputT>  @UnknownKeyFor @NonNull @Initialized Join.WindowByBuilder<KeyT, OutputT> using(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<@UnknownKeyFor @NonNull @Initialized Optional<LeftT>, RightT, OutputT> joinFunc) {
            return this.using(joinFunc, null);
        }
    }

    public static interface ByBuilder<@UnknownKeyFor LeftT, @UnknownKeyFor RightT> {
        public <KeyT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<LeftT, RightT, KeyT> by(@UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, KeyT> var1, @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, KeyT> var2, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> var3);

        default public <KeyT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<LeftT, RightT, KeyT> by(@UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, KeyT> leftKeyExtractor, @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, KeyT> rightKeyExtractor) {
            return this.by(leftKeyExtractor, rightKeyExtractor, null);
        }
    }

    public static interface OfBuilder {
        public <LeftT, RightT> @UnknownKeyFor @NonNull @Initialized ByBuilder<LeftT, RightT> of(@UnknownKeyFor @NonNull @Initialized PCollection<LeftT> var1, @UnknownKeyFor @NonNull @Initialized PCollection<RightT> var2);
    }
}

