/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableBinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.VoidFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Derived(state=StateComplexity.CONSTANT_IF_COMBINABLE, repartitions=1)
public class ReduceWindow<@UnknownKeyFor InputT, @UnknownKeyFor ValueT, @UnknownKeyFor AccT, @UnknownKeyFor OutputT>
extends ShuffleOperator<InputT, Byte, OutputT>
implements TypeAware.Value<ValueT>,
CompositeOperator<InputT, OutputT> {
    private static final @UnknownKeyFor @NonNull @Initialized Byte B_ZERO = 0;
    private final @Nullable @UnknownKeyFor @Initialized ReduceFunctor<ValueT, OutputT> reducer;
    private final @Nullable @UnknownKeyFor @Initialized VoidFunction<AccT> accumulatorFactory;
    private final @Nullable @UnknownKeyFor @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate;
    private final @Nullable @UnknownKeyFor @Initialized CombinableBinaryFunction<AccT> mergeAccumulators;
    private final @Nullable @UnknownKeyFor @Initialized UnaryFunction<AccT, OutputT> outputFn;
    private final @Nullable @UnknownKeyFor @Initialized TypeDescriptor<AccT> accumulatorType;
    private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor;
    private final @Nullable @UnknownKeyFor @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator;
    private final @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized ValueByReduceByBuilder<InputT, InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return ReduceWindow.named(null).of((PCollection)input);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name);
    }

    private ReduceWindow(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType, @UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> reducer, @Nullable @UnknownKeyFor @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator, @Nullable @UnknownKeyFor @Initialized Window<InputT> window, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
        super(name, outputType, e -> B_ZERO, TypeDescriptors.bytes(), window);
        this.reducer = Objects.requireNonNull(reducer);
        this.valueExtractor = valueExtractor;
        this.valueType = valueType;
        this.valueComparator = valueComparator;
        this.accumulatorFactory = null;
        this.accumulate = null;
        this.mergeAccumulators = null;
        this.outputFn = null;
        this.accumulatorType = null;
    }

    private ReduceWindow(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType, @UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> accumulatorFactory, @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> mergeAccumulators, @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, OutputT> outputFn, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<AccT> accumulatorType, @Nullable @UnknownKeyFor @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator, @Nullable @UnknownKeyFor @Initialized Window<InputT> window, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
        super(name, outputType, e -> B_ZERO, TypeDescriptors.bytes(), window);
        this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory);
        this.accumulate = Objects.requireNonNull(accumulate);
        this.mergeAccumulators = Objects.requireNonNull(mergeAccumulators);
        this.outputFn = Objects.requireNonNull(outputFn);
        this.accumulatorType = accumulatorType;
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
        this.valueType = valueType;
        this.valueComparator = valueComparator;
        this.reducer = null;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCombineFnStyle() {
        return this.reducer == null;
    }

    public @UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> getReducer() {
        return Objects.requireNonNull(this.reducer, "Don't call #getReducer is #isCombineFnStyle() == true");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCombinable() {
        return this.isCombineFnStyle() || this.reducer.isCombinable();
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> getValueExtractor() {
        return this.valueExtractor;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer>> getValueComparator() {
        return Optional.ofNullable(this.valueComparator);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<ValueT>> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        ReduceByKey.WindowByBuilder windowBy;
        if (this.isCombinable()) {
            Preconditions.checkState((this.valueComparator == null ? 1 : 0) != 0, (Object)"Sorting is not supported for combinable reducers.");
        }
        if (this.isCombineFnStyle()) {
            windowBy = ReduceByKey.named(this.getName().orElse("") + "::reduce-by").of((PCollection)PCollectionLists.getOnlyElement(inputs)).keyBy(this.getKeyExtractor()).valueBy(this.valueExtractor, this.valueType).combineBy(this.accumulatorFactory, this.accumulate, this.mergeAccumulators, this.outputFn, this.accumulatorType, this.getOutputType().orElse(null));
        } else {
            ReduceByKey.WithSortedValuesBuilder reduceBy = ReduceByKey.named(this.getName().orElse("") + "::reduce-by").of((PCollection)PCollectionLists.getOnlyElement(inputs)).keyBy(this.getKeyExtractor()).valueBy(this.valueExtractor, this.valueType).reduceBy(this.reducer, (TypeDescriptor)this.getOutputType().orElse(null));
            windowBy = this.getValueComparator().isPresent() ? reduceBy.withSortedValues(this.valueComparator) : reduceBy;
        }
        return windowBy.applyIf(this.getWindow().isPresent(), builder -> {
            ReduceByKey.WindowByInternalBuilder cast = (ReduceByKey.WindowByInternalBuilder)((Object)builder);
            return cast.windowBy(this.getWindow().orElseThrow(() -> new IllegalStateException("Unable to resolve windowing for ReduceWindow expansion.")));
        }).outputValues();
    }

    private static class Builder<@UnknownKeyFor InputT, @UnknownKeyFor ValueT, @UnknownKeyFor AccT, @UnknownKeyFor OutputT>
    implements OfBuilder,
    ValueByReduceByBuilder<InputT, ValueT>,
    WithSortedValuesBuilder<ValueT, OutputT>,
    WindowByBuilder<OutputT>,
    TriggeredByBuilder<OutputT>,
    AccumulationModeBuilder<OutputT>,
    WindowedOutputBuilder<OutputT>,
    Builders.Output<OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private final @Nullable @UnknownKeyFor @Initialized ReduceFunctor<ValueT, OutputT> reducer;
        private final @Nullable @UnknownKeyFor @Initialized VoidFunction<AccT> accumulatorFactory;
        private final @Nullable @UnknownKeyFor @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate;
        private final @Nullable @UnknownKeyFor @Initialized CombinableBinaryFunction<AccT> mergeAccumulators;
        private final @Nullable @UnknownKeyFor @Initialized UnaryFunction<AccT, OutputT> outputFn;
        private final @Nullable @UnknownKeyFor @Initialized TypeDescriptor<AccT> accumulatorType;
        private @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private @Nullable @UnknownKeyFor @Initialized UnaryFunction<InputT, ValueT> valueExtractor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType;
        private @Nullable @UnknownKeyFor @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator;

        Builder(@Nullable @UnknownKeyFor @Initialized String name) {
            this.name = name;
            this.reducer = null;
            this.accumulatorFactory = null;
            this.accumulate = null;
            this.mergeAccumulators = null;
            this.outputFn = null;
            this.accumulatorType = null;
        }

        private Builder(@UnknownKeyFor @NonNull @Initialized Builder parent, @UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> reducer) {
            this.name = parent.name;
            this.reducer = Objects.requireNonNull(reducer);
            this.accumulatorFactory = null;
            this.accumulate = null;
            this.mergeAccumulators = null;
            this.outputFn = null;
            this.accumulatorType = null;
            this.input = parent.input;
            this.valueExtractor = parent.valueExtractor;
            this.valueType = parent.valueType;
            this.outputType = parent.outputType;
            this.valueComparator = parent.valueComparator;
        }

        private Builder(@UnknownKeyFor @NonNull @Initialized Builder parent, @UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> accumulatorFactory, @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> mergeAccumulators, @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, OutputT> outputFn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<AccT> accumulatorType) {
            this.name = parent.name;
            this.reducer = null;
            this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory);
            this.accumulate = Objects.requireNonNull(accumulate);
            this.mergeAccumulators = Objects.requireNonNull(mergeAccumulators);
            this.outputFn = Objects.requireNonNull(outputFn);
            this.accumulatorType = accumulatorType;
            this.input = parent.input;
            this.valueExtractor = parent.valueExtractor;
            this.valueType = parent.valueType;
            this.outputType = parent.outputType;
            this.valueComparator = parent.valueComparator;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized ValueByReduceByBuilder<T, T> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Builder cast = this;
            cast.input = Objects.requireNonNull(input);
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized ReduceByBuilder<T> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> valueExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> valueType) {
            Builder cast = this;
            cast.valueExtractor = Objects.requireNonNull(valueExtractor);
            cast.valueType = valueType;
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<ValueT, T> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, T> reducer, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> outputType) {
            Builder<InputT, ValueT, AccT, T> cast = new Builder<InputT, ValueT, AccT, T>(this, reducer);
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public <NewAccT, T> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<T> combineBy(@UnknownKeyFor @NonNull @Initialized VoidFunction<NewAccT> accumulatorFactory, @UnknownKeyFor @NonNull @Initialized BinaryFunction<NewAccT, ValueT, NewAccT> accumulate, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<NewAccT> mergeAccumulators, @UnknownKeyFor @NonNull @Initialized UnaryFunction<NewAccT, T> outputFn, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<NewAccT> accumulatorDescriptor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> outputDescriptor) {
            Builder<InputT, ValueT, NewAccT, T> ret = new Builder<InputT, ValueT, NewAccT, T>(this, accumulatorFactory, accumulate, mergeAccumulators, outputFn, accumulatorDescriptor);
            ret.valueType = this.valueType;
            ret.outputType = outputDescriptor;
            return ret;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<OutputT> withSortedValues(@UnknownKeyFor @NonNull @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator) {
            this.valueComparator = Objects.requireNonNull(valueComparator);
            return this;
        }

        @Override
        public <T extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<OutputT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, T> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<OutputT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<OutputT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<OutputT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<OutputT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<OutputT> withTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<OutputT> withOnTimeBehavior(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> output() {
            if (this.valueExtractor == null) {
                this.valueExtractor = this.identity();
            }
            ReduceWindow rw = this.reducer != null ? new ReduceWindow(this.name, this.valueExtractor, this.valueType, this.reducer, this.valueComparator, this.windowBuilder.getWindow().orElse(null), this.outputType) : new ReduceWindow(this.name, this.valueExtractor, this.valueType, this.accumulatorFactory, this.accumulate, this.mergeAccumulators, this.outputFn, this.accumulatorType, this.valueComparator, this.windowBuilder.getWindow().orElse(null), this.outputType);
            return OperatorTransform.apply(rw, PCollectionList.of(this.input));
        }

        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> identity() {
            return UnaryFunction.identity();
        }
    }

    public static interface WindowedOutputBuilder<@UnknownKeyFor OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<OutputT>>,
    Builders.Output<OutputT> {
    }

    public static interface AccumulationModeBuilder<@UnknownKeyFor OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<OutputT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<OutputT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<@UnknownKeyFor OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<OutputT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<OutputT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger var1);
    }

    public static interface WindowByBuilder<@UnknownKeyFor OutputT>
    extends Builders.WindowBy<TriggeredByBuilder<OutputT>>,
    OptionalMethodBuilder<WindowByBuilder<OutputT>, Builders.Output<OutputT>>,
    Builders.Output<OutputT> {
        @Override
        public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<OutputT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> var1);

        @Override
        default public  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT> applyIf(@UnknownKeyFor @NonNull @Initialized boolean cond, @UnknownKeyFor @NonNull @Initialized UnaryFunction<@UnknownKeyFor @NonNull @Initialized WindowByBuilder<OutputT>,  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT>> fn) {
            Objects.requireNonNull(fn);
            return cond ? fn.apply(this) : this;
        }
    }

    public static interface WithSortedValuesBuilder<@UnknownKeyFor ValueT, @UnknownKeyFor OutputT>
    extends WindowByBuilder<OutputT> {
        public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<OutputT> withSortedValues(@UnknownKeyFor @NonNull @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> var1);
    }

    public static interface ValueByReduceByBuilder<@UnknownKeyFor InputT, @UnknownKeyFor ValueT>
    extends ReduceByBuilder<ValueT> {
        public <T> @UnknownKeyFor @NonNull @Initialized ReduceByBuilder<T> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> var2);

        default public <T> @UnknownKeyFor @NonNull @Initialized ReduceByBuilder<T> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> valueExtractor) {
            return this.valueBy(valueExtractor, null);
        }
    }

    public static interface ReduceByBuilder<@UnknownKeyFor ValueT> {
        default public <OutputT> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<ValueT, OutputT> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunction<ValueT, OutputT> reducer) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)));
        }

        default public <OutputT> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<ValueT, OutputT> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunction<ValueT, OutputT> reducer, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)), outputType);
        }

        default public <OutputT> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<ValueT, OutputT> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> reducer) {
            return this.reduceBy(reducer, null);
        }

        public <OutputT> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<ValueT, OutputT> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> var2);

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized CombinableReduceFunction<ValueT> reducer) {
            return this.reduceBy(ReduceFunctor.of(reducer));
        }

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized CombinableReduceFunction<ValueT> reducer, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<ValueT> outputType) {
            return this.reduceBy(ReduceFunctor.of(reducer), outputType);
        }

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized ReduceByKey.CombineFunctionWithIdentity<ValueT> reduce) {
            return this.combineBy(reduce.identity(), reduce, reduce.valueDesc());
        }

        @Deprecated
        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized ReduceByKey.CombineFunctionWithIdentity<ValueT> reduce, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<ValueT> ignored) {
            return this.combineBy(reduce.identity(), reduce, reduce.valueDesc());
        }

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<ValueT> combineBy(ValueT identity, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<ValueT> reducer) {
            return this.combineBy(identity, reducer, null);
        }

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<ValueT> combineBy(ValueT identity, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<ValueT> reducer, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType) {
            return this.combineBy(() -> identity, reducer, reducer, e -> e, valueType, valueType);
        }

        default public <AccT> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> accumulatorFactory, @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> mergeAccumulators, @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, ValueT> outputFn) {
            return this.combineBy(accumulatorFactory, accumulate, mergeAccumulators, outputFn, null, null);
        }

        public <AccT, OutputT> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<OutputT> combineBy(@UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> var1, @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> var2, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> var3, @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, OutputT> var4, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<AccT> var5, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> var6);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized ValueByReduceByBuilder<InputT, InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> var1);
    }
}

