/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Recommended;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableBinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.VoidFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.OutputValues;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Recommended(reason="Is very recommended to override because of performance in a specific area of (mostly) batch calculations where combiners can be efficiently used in the executor-specific implementation", state=StateComplexity.CONSTANT_IF_COMBINABLE, repartitions=1)
public class ReduceByKey<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor AccT, @UnknownKeyFor OutputT>
extends ShuffleOperator<InputT, KeyT, KV<KeyT, OutputT>>
implements TypeAware.Value<ValueT> {
    private final @Nullable @UnknownKeyFor @Initialized ReduceFunctor<ValueT, OutputT> reducer;
    private final @Nullable @UnknownKeyFor @Initialized VoidFunction<AccT> accumulatorFactory;
    private final @Nullable @UnknownKeyFor @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate;
    private final @Nullable @UnknownKeyFor @Initialized CombinableBinaryFunction<AccT> mergeAccumulators;
    private final @Nullable @UnknownKeyFor @Initialized UnaryFunction<AccT, OutputT> outputFn;
    private final @Nullable @UnknownKeyFor @Initialized TypeDescriptor<AccT> accumulatorType;
    private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor;
    private final @Nullable @UnknownKeyFor @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator;
    private final @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return ReduceByKey.named(null).of((PCollection)input);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name);
    }

    private ReduceByKey(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType, @UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> reducer, @Nullable @UnknownKeyFor @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator, @Nullable @UnknownKeyFor @Initialized Window<InputT> window, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
        this.reducer = Objects.requireNonNull(reducer);
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
        this.valueType = valueType;
        this.valueComparator = valueComparator;
        this.accumulatorFactory = null;
        this.accumulate = null;
        this.mergeAccumulators = null;
        this.outputFn = null;
        this.accumulatorType = null;
    }

    private ReduceByKey(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType, @UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> accumulatorFactory, @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> mergeAccumulators, @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, OutputT> outputFn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<AccT> accumulatorType, @Nullable @UnknownKeyFor @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator, @Nullable @UnknownKeyFor @Initialized Window<InputT> window, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
        this.reducer = null;
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
        this.valueType = valueType;
        this.valueComparator = valueComparator;
        this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory);
        this.accumulate = Objects.requireNonNull(accumulate);
        this.mergeAccumulators = Objects.requireNonNull(mergeAccumulators);
        this.outputFn = Objects.requireNonNull(outputFn);
        this.accumulatorType = accumulatorType;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCombineFnStyle() {
        return this.reducer == null;
    }

    public @UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> getReducer() {
        return Objects.requireNonNull(this.reducer, "Don't call #getReducer when #isCombinableFnStyle() == true");
    }

    public @UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> getAccumulatorFactory() {
        return Objects.requireNonNull(this.accumulatorFactory, "Don't vall #getAccumulatorFactory when #isCombinableFnStyle() == false");
    }

    public @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> getAccumulate() {
        return Objects.requireNonNull(this.accumulate, "Don't vall #getAccumulate when #isCombinableFnStyle() == false");
    }

    public @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> getMergeAccumulators() {
        return Objects.requireNonNull(this.mergeAccumulators, "Don't vall #getMergeAccumulators when #isCombinableFnStyle() == false");
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, OutputT> getOutputFn() {
        return Objects.requireNonNull(this.outputFn, "Don't vall #getOutputFn when #isCombinableFnStyle() == false");
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<AccT> getAccumulatorType() {
        return this.accumulatorType;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCombinable() {
        return this.isCombineFnStyle() || this.reducer.isCombinable();
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> getValueExtractor() {
        return this.valueExtractor;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer>> getValueComparator() {
        return Optional.ofNullable(this.valueComparator);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<ValueT>> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    static class Builder<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor AccT, @UnknownKeyFor OutputT>
    implements OfBuilder,
    KeyByBuilder<InputT>,
    ValueByReduceByBuilder<InputT, KeyT, ValueT>,
    WithSortedValuesBuilder<KeyT, ValueT, OutputT>,
    WindowByInternalBuilder<InputT, KeyT, OutputT>,
    WindowByBuilder<KeyT, OutputT>,
    TriggeredByBuilder<KeyT, OutputT>,
    AccumulationModeBuilder<KeyT, OutputT>,
    WindowedOutputBuilder<KeyT, OutputT>,
    OutputBuilder<KeyT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType;
        private @Nullable @UnknownKeyFor @Initialized UnaryFunction<InputT, ValueT> valueExtractor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType;
        private @Nullable @UnknownKeyFor @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator;
        private final @Nullable @UnknownKeyFor @Initialized ReduceFunctor<ValueT, OutputT> reducer;
        private final @Nullable @UnknownKeyFor @Initialized VoidFunction<AccT> accumulatorFactory;
        private final @Nullable @UnknownKeyFor @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate;
        private final @Nullable @UnknownKeyFor @Initialized CombinableBinaryFunction<AccT> mergeAccumulators;
        private final @Nullable @UnknownKeyFor @Initialized UnaryFunction<AccT, OutputT> outputFn;
        private final @Nullable @UnknownKeyFor @Initialized TypeDescriptor<AccT> accumulatorTypeDescriptor;

        Builder(@Nullable @UnknownKeyFor @Initialized String name) {
            this.name = name;
            this.reducer = null;
            this.accumulatorFactory = null;
            this.accumulate = null;
            this.mergeAccumulators = null;
            this.outputFn = null;
            this.accumulatorTypeDescriptor = null;
        }

        private Builder(@UnknownKeyFor @NonNull @Initialized Builder parent, @UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> accumulatorFactory, @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> mergeAccumulators, @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, OutputT> outputFn, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<AccT> accumulatorTypeDescriptor) {
            this.name = parent.name;
            this.input = parent.input;
            this.keyExtractor = parent.keyExtractor;
            this.keyType = parent.keyType;
            this.valueExtractor = parent.valueExtractor;
            this.valueType = parent.valueType;
            this.outputType = parent.outputType;
            this.valueComparator = parent.valueComparator;
            this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory);
            this.accumulate = Objects.requireNonNull(accumulate);
            this.mergeAccumulators = Objects.requireNonNull(mergeAccumulators);
            this.outputFn = Objects.requireNonNull(outputFn);
            this.accumulatorTypeDescriptor = accumulatorTypeDescriptor;
            this.reducer = null;
        }

        private Builder(@UnknownKeyFor @NonNull @Initialized Builder parent, @UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> reducer) {
            this.name = parent.name;
            this.input = parent.input;
            this.keyExtractor = parent.keyExtractor;
            this.keyType = parent.keyType;
            this.valueExtractor = parent.valueExtractor;
            this.valueType = parent.valueType;
            this.outputType = parent.outputType;
            this.valueComparator = parent.valueComparator;
            this.accumulatorFactory = null;
            this.accumulate = null;
            this.mergeAccumulators = null;
            this.outputFn = null;
            this.accumulatorTypeDescriptor = null;
            this.reducer = Objects.requireNonNull(reducer);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<T> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Builder cast = this;
            cast.input = input;
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized ValueByReduceByBuilder<InputT, T, InputT> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> keyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> keyType) {
            Builder cast = this;
            cast.keyExtractor = Objects.requireNonNull(keyExtractor);
            cast.keyType = keyType;
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized ReduceByBuilder<KeyT, T> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> valueExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> valueType) {
            Builder cast = this;
            cast.valueExtractor = Objects.requireNonNull(valueExtractor);
            cast.valueType = valueType;
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<KeyT, ValueT, T> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, T> reducer, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> outputType) {
            Builder<InputT, KeyT, ValueT, AccT, T> cast = new Builder<InputT, KeyT, ValueT, AccT, T>(this, reducer);
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public <NewAccT, T> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, T> combineBy(@UnknownKeyFor @NonNull @Initialized VoidFunction<NewAccT> accumulatorFactory, @UnknownKeyFor @NonNull @Initialized BinaryFunction<NewAccT, ValueT, NewAccT> accumulate, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<NewAccT> mergeAccumulators, @UnknownKeyFor @NonNull @Initialized UnaryFunction<NewAccT, T> outputFn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<NewAccT> accumulatorDescriptor, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> outputDescriptor) {
            Builder<InputT, KeyT, ValueT, NewAccT, T> ret = new Builder<InputT, KeyT, ValueT, NewAccT, T>(this, accumulatorFactory, accumulate, mergeAccumulators, outputFn, accumulatorDescriptor);
            ret.valueType = this.valueType;
            ret.outputType = outputDescriptor;
            return ret;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, OutputT> withSortedValues(@UnknownKeyFor @NonNull @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> valueComparator) {
            this.valueComparator = Objects.requireNonNull(valueComparator);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OutputBuilder<KeyT, OutputT> windowBy(@UnknownKeyFor @NonNull @Initialized Window<InputT> window) {
            this.windowBuilder.setWindow(window);
            return this;
        }

        @Override
        public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<KeyT, OutputT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<KeyT, OutputT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> withTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> withOnTimeBehavior(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> output() {
            return OperatorTransform.apply(this.createOperator(), PCollectionList.of(this.input));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> outputValues() {
            return OperatorTransform.apply(new OutputValues(this.name, this.outputType, this.createOperator()), PCollectionList.of(this.input));
        }

        private @UnknownKeyFor @NonNull @Initialized ReduceByKey<InputT, KeyT, ValueT, AccT, OutputT> createOperator() {
            if (this.valueExtractor == null) {
                this.valueExtractor = this.identity();
            }
            if (this.reducer != null) {
                return new ReduceByKey(this.name, this.keyExtractor, this.keyType, this.valueExtractor, this.valueType, this.reducer, this.valueComparator, this.windowBuilder.getWindow().orElse(null), TypeDescriptors.kvs(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeAwareness.orObjects(Optional.ofNullable(this.outputType))));
            }
            return new ReduceByKey(this.name, this.keyExtractor, this.keyType, this.valueExtractor, this.valueType, this.accumulatorFactory, this.accumulate, this.mergeAccumulators, this.outputFn, this.accumulatorTypeDescriptor, this.valueComparator, this.windowBuilder.getWindow().orElse(null), TypeDescriptors.kvs(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeAwareness.orObjects(Optional.ofNullable(this.outputType))));
        }

        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> identity() {
            return UnaryFunction.identity();
        }
    }

    public static interface OutputBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.Output<KV<KeyT, OutputT>>,
    Builders.OutputValues<KeyT, OutputT> {
    }

    public static interface WindowedOutputBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
    }

    public static interface AccumulationModeBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT, OutputT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT, OutputT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<KeyT, OutputT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger var1);
    }

    public static interface WindowByBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.WindowBy<TriggeredByBuilder<KeyT, OutputT>>,
    OptionalMethodBuilder<WindowByBuilder<KeyT, OutputT>, OutputBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
        @Override
        public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<KeyT, OutputT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> var1);

        @Override
        default public @UnknownKeyFor @NonNull @Initialized OutputBuilder<KeyT, OutputT> applyIf(@UnknownKeyFor @NonNull @Initialized boolean cond, @UnknownKeyFor @NonNull @Initialized UnaryFunction<@UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, OutputT>, @UnknownKeyFor @NonNull @Initialized OutputBuilder<KeyT, OutputT>> fn) {
            Objects.requireNonNull(fn);
            return cond ? fn.apply(this) : this;
        }
    }

    @Internal
    public static interface WindowByInternalBuilder<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor OutputT> {
        public @UnknownKeyFor @NonNull @Initialized OutputBuilder<KeyT, OutputT> windowBy(@UnknownKeyFor @NonNull @Initialized Window<InputT> var1);
    }

    public static interface WithSortedValuesBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor OutputT>
    extends WindowByBuilder<KeyT, OutputT> {
        public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, OutputT> withSortedValues(@UnknownKeyFor @NonNull @Initialized BinaryFunction<ValueT, ValueT, @UnknownKeyFor @NonNull @Initialized Integer> var1);
    }

    public static interface ValueByReduceByBuilder<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends ReduceByBuilder<KeyT, ValueT> {
        public <T> @UnknownKeyFor @NonNull @Initialized ReduceByBuilder<KeyT, T> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> var2);

        default public <T> @UnknownKeyFor @NonNull @Initialized ReduceByBuilder<KeyT, T> valueBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> valueExtractor) {
            return this.valueBy(valueExtractor, null);
        }
    }

    public static interface ReduceByBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT> {
        default public <OutputT> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunction<ValueT, OutputT> reducer) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)));
        }

        default public <OutputT> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunction<ValueT, OutputT> reducer, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> outputType) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)), outputType);
        }

        default public <OutputT> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> reducer) {
            return this.reduceBy(reducer, null);
        }

        public <OutputT> @UnknownKeyFor @NonNull @Initialized WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(@UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> var2);

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized CombinableReduceFunction<ValueT> reducer) {
            return this.reduceBy(ReduceFunctor.of(reducer));
        }

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized CombinableReduceFunction<ValueT> reducer, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<ValueT> outputType) {
            return this.reduceBy(ReduceFunctor.of(reducer), outputType);
        }

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized CombineFunctionWithIdentity<ValueT> reduce) {
            return this.combineBy(reduce.identity(), reduce, reduce.valueDesc());
        }

        @Deprecated
        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized CombineFunctionWithIdentity<ValueT> reduce, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<ValueT> ignored) {
            return this.combineBy(reduce);
        }

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT> combineBy(ValueT identity, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<ValueT> reducer) {
            return this.combineBy(identity, reducer, null);
        }

        default public @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT> combineBy(ValueT identity, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<ValueT> reducer, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<ValueT> valueType) {
            return this.combineBy(() -> identity, reducer, reducer, e -> e, valueType, valueType);
        }

        default public <AccT> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, ValueT> combineBy(@UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> accumulatorFactory, @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> accumulate, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> mergeAccumulators, @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, ValueT> outputFn) {
            return this.combineBy(accumulatorFactory, accumulate, mergeAccumulators, outputFn, null, null);
        }

        public <AccT, OutputT> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, OutputT> combineBy(@UnknownKeyFor @NonNull @Initialized VoidFunction<AccT> var1, @UnknownKeyFor @NonNull @Initialized BinaryFunction<AccT, ValueT, AccT> var2, @UnknownKeyFor @NonNull @Initialized CombinableBinaryFunction<AccT> var3, @UnknownKeyFor @NonNull @Initialized UnaryFunction<AccT, OutputT> var4, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<AccT> var5, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> var6);
    }

    public static interface KeyByBuilder<@UnknownKeyFor InputT>
    extends Builders.KeyBy<InputT> {
        public <T> @UnknownKeyFor @NonNull @Initialized ValueByReduceByBuilder<InputT, T, InputT> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> var1, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> var2);

        default public <T> @UnknownKeyFor @NonNull @Initialized ValueByReduceByBuilder<InputT, T, InputT> keyBy(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, T> keyExtractor) {
            return this.keyBy((UnaryFunction)keyExtractor, (TypeDescriptor)null);
        }
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized KeyByBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> var1);
    }

    public static interface CombineFunctionWithIdentity<@UnknownKeyFor T>
    extends CombinableBinaryFunction<T> {
        public T identity();

        default public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> valueDesc() {
            return null;
        }
    }
}

