/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.MapElements;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class OutputValues<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
extends Operator<OutputT>
implements CompositeOperator<InputT, OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized Operator<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> keyedOperator;

    OutputValues(@Nullable @UnknownKeyFor @Initialized String name, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType, @UnknownKeyFor @NonNull @Initialized Operator<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> keyedOperator) {
        super(name, outputType);
        this.keyedOperator = keyedOperator;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        PCollection keyedOutput = OperatorTransform.apply(this.keyedOperator, inputs);
        return MapElements.named("ExtractValues").of(keyedOutput).using(KV::getValue, (TypeDescriptor)this.getOutputType().orElse(null)).output();
    }
}

