/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunctionEnv;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Context;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class MapElements<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends Operator<OutputT>
implements CompositeOperator<InputT, OutputT>,
TypeAware.Output<OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized UnaryFunctionEnv<InputT, OutputT> mapper;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return MapElements.named(null).of((PCollection)input);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name);
    }

    private MapElements(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryFunctionEnv<InputT, OutputT> mapper, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType) {
        super(name, outputType);
        this.mapper = mapper;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        return FlatMap.named(this.getName().orElse(null)).of((PCollection)PCollectionLists.getOnlyElement(inputs)).using((elem, coll) -> coll.collect(this.getMapper().apply(elem, coll.asContext())), this.getOutputType().orElse(null)).output();
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunctionEnv<InputT, OutputT> getMapper() {
        return this.mapper;
    }

    private static class Builder<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements OfBuilder,
    UsingBuilder<InputT>,
    Builders.Output<OutputT> {
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunctionEnv<InputT, OutputT> mapper;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType;

        Builder(@Nullable @UnknownKeyFor @Initialized String name) {
            this.name = name;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized UsingBuilder<T> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Builder cast = this;
            cast.input = input;
            return cast;
        }

        @Override
        public <T>  @UnknownKeyFor @NonNull @Initialized Builders.Output<T> using(@UnknownKeyFor @NonNull @Initialized UnaryFunctionEnv<InputT, T> mapper, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> outputType) {
            Builder cast = this;
            cast.mapper = mapper;
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> output() {
            MapElements operator = new MapElements(this.name, this.mapper, this.outputType);
            return OperatorTransform.apply(operator, PCollectionList.of(this.input));
        }
    }

    public static interface UsingBuilder<@UnknownKeyFor InputT> {
        default public <OutputT>  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT> using(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, OutputT> mapper) {
            return this.using(mapper, null);
        }

        default public <OutputT>  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT> using(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, OutputT> mapper, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType) {
            return this.using((InputT el, Context ctx) -> mapper.apply(el), outputType);
        }

        default public <OutputT>  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT> using(@UnknownKeyFor @NonNull @Initialized UnaryFunctionEnv<InputT, OutputT> mapper) {
            return this.using(mapper, null);
        }

        public <OutputT>  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT> using(@UnknownKeyFor @NonNull @Initialized UnaryFunctionEnv<InputT, OutputT> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> var2);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> var1);
    }
}

