/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Recommended;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.OutputValues;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Recommended(reason="Might be useful to override because of performance reasons in a specific join types (e.g. sort join), which might reduce the space complexity", state=StateComplexity.LINEAR, repartitions=1)
public class Join<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
extends ShuffleOperator<Object, KeyT, KV<KeyT, OutputT>> {
    private final @UnknownKeyFor @NonNull @Initialized Type type;
    private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, KeyT> leftKeyExtractor;
    private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, KeyT> rightKeyExtractor;
    private final @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> functor;

    public static <LeftT, RightT> @UnknownKeyFor @NonNull @Initialized ByBuilder<LeftT, RightT> of(@UnknownKeyFor @NonNull @Initialized PCollection<LeftT> left, @UnknownKeyFor @NonNull @Initialized PCollection<RightT> right) {
        return Join.named(null).of(left, right);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name, Type.INNER);
    }

    private Join(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, KeyT> leftKeyExtractor, @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, KeyT> rightKeyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType, @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> functor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> outputType, @Nullable @UnknownKeyFor @Initialized Window<@UnknownKeyFor @NonNull @Initialized Object> window) {
        super(name, outputType, null, keyType, window);
        this.type = type;
        this.leftKeyExtractor = leftKeyExtractor;
        this.rightKeyExtractor = rightKeyExtractor;
        this.functor = functor;
    }

    public @UnknownKeyFor @NonNull @Initialized Type getType() {
        return this.type;
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, KeyT> getLeftKeyExtractor() {
        return this.leftKeyExtractor;
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, KeyT> getRightKeyExtractor() {
        return this.rightKeyExtractor;
    }

    public @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> getJoiner() {
        return this.functor;
    }

    static class Builder<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    implements OfBuilder,
    ByBuilder<LeftT, RightT>,
    UsingBuilder<LeftT, RightT, KeyT>,
    WindowByBuilder<KeyT, OutputT>,
    TriggeredByBuilder<KeyT, OutputT>,
    AccumulationModeBuilder<KeyT, OutputT>,
    WindowedOutputBuilder<KeyT, OutputT>,
    OutputBuilder<KeyT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized WindowBuilder<@UnknownKeyFor @NonNull @Initialized Object> windowBuilder = new WindowBuilder();
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized Type type;
        private @UnknownKeyFor @NonNull @Initialized PCollection<LeftT> left;
        private @UnknownKeyFor @NonNull @Initialized PCollection<RightT> right;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, KeyT> leftKeyExtractor;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, KeyT> rightKeyExtractor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<KeyT> keyType;
        private @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joinFunc;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType;

        Builder(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized Type type) {
            this.name = name;
            this.type = type;
        }

        public <FirstT, SecondT> @UnknownKeyFor @NonNull @Initialized ByBuilder<FirstT, SecondT> of(@UnknownKeyFor @NonNull @Initialized PCollection<FirstT> left, @UnknownKeyFor @NonNull @Initialized PCollection<SecondT> right) {
            Builder cast = this;
            cast.left = Objects.requireNonNull(left);
            cast.right = Objects.requireNonNull(right);
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized UsingBuilder<LeftT, RightT, T> by(@UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, T> leftKeyExtractor, @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, T> rightKeyExtractor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> keyType) {
            Builder cast = this;
            cast.leftKeyExtractor = leftKeyExtractor;
            cast.rightKeyExtractor = rightKeyExtractor;
            cast.keyType = keyType;
            return cast;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, T> using(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, T> joinFunc, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> outputType) {
            Builder cast = this;
            cast.joinFunc = Objects.requireNonNull(joinFunc);
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized TriggeredByBuilder<KeyT, OutputT> windowBy(@UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulationModeBuilder<KeyT, OutputT> triggeredBy(@UnknownKeyFor @NonNull @Initialized Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> accumulationMode(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(@UnknownKeyFor @NonNull @Initialized Duration allowedLateness, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> withTimestampCombiner(@UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedOutputBuilder<KeyT, OutputT> withOnTimeBehavior(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> output() {
            PCollectionList inputs = PCollectionList.of(Arrays.asList(this.left, this.right));
            return OperatorTransform.apply(this.createOperator(), inputs);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> outputValues() {
            PCollectionList inputs = PCollectionList.of(Arrays.asList(this.left, this.right));
            return OperatorTransform.apply(new OutputValues(this.name, this.outputType, this.createOperator()), inputs);
        }

        private @UnknownKeyFor @NonNull @Initialized Join<LeftT, RightT, KeyT, OutputT> createOperator() {
            return new Join(this.name, this.type, this.leftKeyExtractor, this.rightKeyExtractor, this.keyType, this.joinFunc, TypeDescriptors.kvs(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeAwareness.orObjects(Optional.ofNullable(this.outputType))), this.windowBuilder.getWindow().orElse(null));
        }
    }

    public static interface OutputBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.Output<KV<KeyT, OutputT>>,
    Builders.OutputValues<KeyT, OutputT> {
    }

    public static interface WindowedOutputBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
    }

    public static interface AccumulationModeBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT, OutputT>> {
    }

    public static interface TriggeredByBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT, OutputT>> {
    }

    public static interface WindowByBuilder<@UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends OptionalMethodBuilder<WindowByBuilder<KeyT, OutputT>, OutputBuilder<KeyT, OutputT>>,
    Builders.WindowBy<TriggeredByBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
        @Override
        default public @UnknownKeyFor @NonNull @Initialized OutputBuilder<KeyT, OutputT> applyIf(@UnknownKeyFor @NonNull @Initialized boolean cond, @UnknownKeyFor @NonNull @Initialized UnaryFunction<@UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, OutputT>, @UnknownKeyFor @NonNull @Initialized OutputBuilder<KeyT, OutputT>> fn) {
            return cond ? Objects.requireNonNull(fn).apply(this) : this;
        }
    }

    public static interface UsingBuilder<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT> {
        public <OutputT> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, OutputT> using(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> var1, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> var2);

        default public <OutputT> @UnknownKeyFor @NonNull @Initialized WindowByBuilder<KeyT, OutputT> using(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joinFunc) {
            return this.using(joinFunc, null);
        }
    }

    public static interface ByBuilder<@UnknownKeyFor LeftT, @UnknownKeyFor RightT> {
        public <K> @UnknownKeyFor @NonNull @Initialized UsingBuilder<LeftT, RightT, K> by(@UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, K> var1, @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, K> var2, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<K> var3);

        default public <T> @UnknownKeyFor @NonNull @Initialized UsingBuilder<LeftT, RightT, T> by(@UnknownKeyFor @NonNull @Initialized UnaryFunction<LeftT, T> leftKeyExtractor, @UnknownKeyFor @NonNull @Initialized UnaryFunction<RightT, T> rightKeyExtractor) {
            return this.by(leftKeyExtractor, rightKeyExtractor, null);
        }
    }

    public static interface OfBuilder {
        public <LeftT, RightT> @UnknownKeyFor @NonNull @Initialized ByBuilder<LeftT, RightT> of(@UnknownKeyFor @NonNull @Initialized PCollection<LeftT> var1, @UnknownKeyFor @NonNull @Initialized PCollection<RightT> var2);
    }

    public static enum Type {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

