/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Basic;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ExtractEventTime;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Basic(state=StateComplexity.ZERO, repartitions=0)
public class FlatMap<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends Operator<OutputT>
implements TypeAware.Output<OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputT> functor;
    private final @Nullable @UnknownKeyFor @Initialized ExtractEventTime<InputT> eventTimeFn;
    private final @UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return FlatMap.named(null).of((PCollection)input);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name);
    }

    private FlatMap(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputT> functor, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType, @Nullable @UnknownKeyFor @Initialized ExtractEventTime<InputT> evtTimeFn, @UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew) {
        super(name, outputType);
        this.functor = functor;
        this.eventTimeFn = evtTimeFn;
        this.allowedTimestampSkew = Objects.requireNonNull(allowedTimestampSkew);
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputT> getFunctor() {
        return this.functor;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT>> getEventTimeExtractor() {
        return Optional.ofNullable(this.eventTimeFn);
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
        return this.allowedTimestampSkew;
    }

    public static class Builder<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements OfBuilder,
    UsingBuilder<InputT>,
    EventTimeBuilder<InputT, OutputT>,
    Builders.Output<OutputT> {
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private @UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputT> functor;
        private @Nullable @UnknownKeyFor @Initialized TypeDescriptor<OutputT> outputType;
        private @Nullable @UnknownKeyFor @Initialized ExtractEventTime<InputT> evtTimeFn;
        private @UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew = Duration.millis((long)Long.MAX_VALUE);

        Builder(@Nullable @UnknownKeyFor @Initialized String name) {
            this.name = name;
        }

        public <InputLocalT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputLocalT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputLocalT> input) {
            Builder cast = this;
            cast.input = Objects.requireNonNull(input);
            return cast;
        }

        @Override
        public <OutputLocalT> @UnknownKeyFor @NonNull @Initialized EventTimeBuilder<InputT, OutputLocalT> using(@UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputLocalT> functor) {
            return this.using(functor, (TypeDescriptor<OutputLocalT>)null);
        }

        @Override
        public <OutputLocalT> @UnknownKeyFor @NonNull @Initialized EventTimeBuilder<InputT, OutputLocalT> using(@UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputLocalT> functor, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputLocalT> outputType) {
            Builder cast = this;
            cast.functor = Objects.requireNonNull(functor);
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT> eventTimeBy(@UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> eventTimeFn, @Nullable @UnknownKeyFor @Initialized Duration timestampSkew) {
            this.evtTimeFn = Objects.requireNonNull(eventTimeFn);
            this.allowedTimestampSkew = (Duration)MoreObjects.firstNonNull((Object)timestampSkew, (Object)Duration.millis((long)Long.MAX_VALUE));
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> output() {
            return OperatorTransform.apply(new FlatMap(this.name, this.functor, this.outputType, this.evtTimeFn, this.allowedTimestampSkew), PCollectionList.of(this.input));
        }
    }

    public static interface EventTimeBuilder<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends Builders.Output<OutputT> {
        default public  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT> eventTimeBy(@UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> eventTimeFn) {
            return this.eventTimeBy(eventTimeFn, null);
        }

        public  @UnknownKeyFor @NonNull @Initialized Builders.Output<OutputT> eventTimeBy(@UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> var1, @Nullable @UnknownKeyFor @Initialized Duration var2);
    }

    public static interface UsingBuilder<@UnknownKeyFor InputT> {
        public <OutputT> @UnknownKeyFor @NonNull @Initialized EventTimeBuilder<InputT, OutputT> using(@UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputT> var1);

        public <OutputT> @UnknownKeyFor @NonNull @Initialized EventTimeBuilder<InputT, OutputT> using(@UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputT> var1, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> var2);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> var1);
    }
}

