/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryPredicate;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class Filter<@UnknownKeyFor InputT>
extends Operator<InputT>
implements CompositeOperator<InputT, InputT> {
    private final @UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> predicate;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized ByBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return Filter.named(null).of((PCollection)input);
    }

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name);
    }

    private Filter(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> predicate, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<InputT> outputType) {
        super(name, outputType);
        this.predicate = predicate;
    }

    public @UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> getPredicate() {
        return this.predicate;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<InputT> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        return FlatMap.named(this.getName().orElse(null)).of((PCollection)PCollectionLists.getOnlyElement(inputs)).using((element, collector) -> {
            if (((Boolean)this.getPredicate().apply(element)).booleanValue()) {
                collector.collect(element);
            }
        }, this.getOutputType().orElse(null)).output();
    }

    private static class Builder<@UnknownKeyFor InputT>
    implements OfBuilder,
    ByBuilder<InputT>,
    Builders.Output<InputT> {
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private @UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> predicate;

        private Builder(@Nullable @UnknownKeyFor @Initialized String name) {
            this.name = name;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized ByBuilder<T> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Builder cast = this;
            cast.input = Objects.requireNonNull(input);
            return cast;
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized Builders.Output<InputT> by(@UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> predicate) {
            this.predicate = Objects.requireNonNull(predicate);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<InputT> output() {
            Filter filter = new Filter(this.name, this.predicate, this.input.getTypeDescriptor());
            return OperatorTransform.apply(filter, PCollectionList.of(this.input));
        }
    }

    public static interface ByBuilder<@UnknownKeyFor InputT> {
        public  @UnknownKeyFor @NonNull @Initialized Builders.Output<InputT> by(@UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> var1);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized ByBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> var1);
    }
}

