/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ExtractEventTime;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class AssignEventTime<@UnknownKeyFor InputT>
extends Operator<InputT>
implements CompositeOperator<InputT, InputT> {
    private final @UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> eventTimeExtractor;
    private final @Nullable @UnknownKeyFor @Initialized Duration allowedTimestampSkew;

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@Nullable @UnknownKeyFor @Initialized String name) {
        return new Builder(name);
    }

    public static <InputT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return AssignEventTime.named(null).of((PCollection)input);
    }

    private AssignEventTime(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> eventTimeExtractor, @Nullable @UnknownKeyFor @Initialized Duration allowedTimestampSkew, @Nullable @UnknownKeyFor @Initialized TypeDescriptor<InputT> outputType) {
        super(name, outputType);
        this.eventTimeExtractor = eventTimeExtractor;
        this.allowedTimestampSkew = allowedTimestampSkew;
    }

    public @UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> getEventTimeExtractor() {
        return this.eventTimeExtractor;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<InputT> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        PCollection<InputT> input = PCollectionLists.getOnlyElement(inputs);
        return FlatMap.named(this.getName().orElse(null)).of((PCollection)input).using((element, coll) -> coll.collect(element), input.getTypeDescriptor()).eventTimeBy(this.getEventTimeExtractor(), this.allowedTimestampSkew).output();
    }

    public static class Builder<@UnknownKeyFor InputT>
    implements OfBuilder,
    UsingBuilder<InputT>,
    Builders.Output<InputT> {
        private final @Nullable @UnknownKeyFor @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private @UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> eventTimeExtractor;
        private @Nullable @UnknownKeyFor @Initialized Duration allowedTimestampSkew = null;

        private Builder(@Nullable @UnknownKeyFor @Initialized String name) {
            this.name = name;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized UsingBuilder<T> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Builder cast = this;
            cast.input = input;
            return cast;
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized Builders.Output<InputT> using(@UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> eventTimeExtractor) {
            this.eventTimeExtractor = eventTimeExtractor;
            return this;
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized Builders.Output<InputT> using(@UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> eventTimeExtractor, @UnknownKeyFor @NonNull @Initialized Duration allowedTimestampSkew) {
            this.allowedTimestampSkew = allowedTimestampSkew;
            return this.using(eventTimeExtractor);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<InputT> output() {
            return OperatorTransform.apply(new AssignEventTime(this.name, this.eventTimeExtractor, this.allowedTimestampSkew, this.input.getTypeDescriptor()), PCollectionList.of(this.input));
        }
    }

    public static interface UsingBuilder<@UnknownKeyFor InputT> {
        public  @UnknownKeyFor @NonNull @Initialized Builders.Output<InputT> using(@UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> var1);

        public  @UnknownKeyFor @NonNull @Initialized Builders.Output<InputT> using(@UnknownKeyFor @NonNull @Initialized ExtractEventTime<InputT> var1, @UnknownKeyFor @NonNull @Initialized Duration var2);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> var1);
    }
}

