/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.lib;

import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryPredicate;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Filter;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class Split {
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_NAME = "Split";
    static final @UnknownKeyFor @NonNull @Initialized String POSITIVE_FILTER_SUFFIX = "-positive";
    static final @UnknownKeyFor @NonNull @Initialized String NEGATIVE_FILTER_SUFFIX = "-negative";

    public static @UnknownKeyFor @NonNull @Initialized OfBuilder named(@UnknownKeyFor @NonNull @Initialized String name) {
        return new OfBuilder(name);
    }

    public static <InputT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        return new UsingBuilder<InputT>(DEFAULT_NAME, input);
    }

    public static class Output<@UnknownKeyFor T> {
        private final @UnknownKeyFor @NonNull @Initialized PCollection<T> positive;
        private final @UnknownKeyFor @NonNull @Initialized PCollection<T> negative;

        private Output(@UnknownKeyFor @NonNull @Initialized PCollection<T> positive, @UnknownKeyFor @NonNull @Initialized PCollection<T> negative) {
            this.positive = Objects.requireNonNull(positive);
            this.negative = Objects.requireNonNull(negative);
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> positive() {
            return this.positive;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> negative() {
            return this.negative;
        }
    }

    public static class OutputBuilder<@UnknownKeyFor InputT> {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;
        private final @UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> predicate;

        OutputBuilder(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input, @UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> predicate) {
            this.name = Objects.requireNonNull(name);
            this.input = Objects.requireNonNull(input);
            this.predicate = Objects.requireNonNull(predicate);
        }

        public @UnknownKeyFor @NonNull @Initialized Output<InputT> output() {
            PCollection<InputT> positiveOutput = Filter.named(this.name + Split.POSITIVE_FILTER_SUFFIX).of((PCollection)this.input).by(this.predicate).output();
            PCollection negativeOutput = Filter.named(this.name + Split.NEGATIVE_FILTER_SUFFIX).of((PCollection)this.input).by(what -> (Boolean)this.predicate.apply(what) == false).output();
            return new Output(positiveOutput, negativeOutput);
        }
    }

    public static class UsingBuilder<@UnknownKeyFor InputT> {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input;

        UsingBuilder(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            this.name = Objects.requireNonNull(name);
            this.input = Objects.requireNonNull(input);
        }

        public @UnknownKeyFor @NonNull @Initialized OutputBuilder<InputT> using(@UnknownKeyFor @NonNull @Initialized UnaryPredicate<InputT> predicate) {
            return new OutputBuilder<InputT>(this.name, this.input, predicate);
        }
    }

    public static class OfBuilder {
        private final @UnknownKeyFor @NonNull @Initialized String name;

        OfBuilder(@UnknownKeyFor @NonNull @Initialized String name) {
            this.name = Objects.requireNonNull(name);
        }

        public <InputT> @UnknownKeyFor @NonNull @Initialized UsingBuilder<InputT> of(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            return new UsingBuilder<InputT>(this.name, input);
        }
    }
}

