/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.util;

import java.lang.reflect.Constructor;

public class InstanceUtils {
    public static <T> T create(Class<T> cls) {
        try {
            Constructor<T> constr = cls.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T create(String className, Class<T> superType) {
        return InstanceUtils.create(InstanceUtils.forName(className, superType));
    }

    public static <T> Class<? extends T> forName(String className, Class<T> superType) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (superType.isAssignableFrom(cls)) {
                return cls;
            }
            throw new IllegalStateException(className + " is not " + superType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

