/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.stability.Experimental;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.TranslatorProvider;

@Experimental
public class CompositeProvider
implements TranslatorProvider {
    private final List<TranslatorProvider> orderedTranslatorsChain;

    public static CompositeProvider of(List<TranslatorProvider> orderedTranslatorsChain) {
        return new CompositeProvider(orderedTranslatorsChain);
    }

    public static CompositeProvider of(TranslatorProvider ... orderedTranslatorsChain) {
        Objects.requireNonNull(orderedTranslatorsChain);
        return new CompositeProvider(Arrays.asList(orderedTranslatorsChain));
    }

    private CompositeProvider(List<TranslatorProvider> orderedTranslatorsChain) {
        Objects.requireNonNull(orderedTranslatorsChain);
        this.orderedTranslatorsChain = Collections.unmodifiableList(orderedTranslatorsChain);
    }

    @Override
    public <InputT, OutputT, OperatorT extends Operator<OutputT>> Optional<OperatorTranslator<InputT, OutputT, OperatorT>> findTranslator(OperatorT operator) {
        for (TranslatorProvider provider : this.orderedTranslatorsChain) {
            Optional maybeTranslator = provider.findTranslator(operator);
            if (!maybeTranslator.isPresent() || !maybeTranslator.get().canTranslate(operator)) continue;
            return maybeTranslator;
        }
        return Optional.empty();
    }
}

