/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate.collector;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Counter;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Histogram;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Timer;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Collector;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Context;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SingleValueCollector<T>
implements Collector<T>,
Serializable {
    private static final String UNSUPPORTED = "Accumulators are supported for named operators only.";
    private final AccumulatorProvider accumulators;
    private final @Nullable String operatorName;
    private T elem;

    public SingleValueCollector(AccumulatorProvider accumulators, @Nullable String operatorName) {
        this.accumulators = accumulators;
        this.operatorName = operatorName;
    }

    public T get() {
        return this.elem;
    }

    @Override
    public void collect(T elem) {
        this.elem = elem;
    }

    @Override
    public Context asContext() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Counter getCounter(String name) {
        return this.accumulators.getCounter(Objects.requireNonNull(this.operatorName, UNSUPPORTED), name);
    }

    @Override
    public Histogram getHistogram(String name) {
        return this.accumulators.getHistogram(Objects.requireNonNull(this.operatorName, UNSUPPORTED), name);
    }

    @Override
    public Timer getTimer(String name) {
        return this.accumulators.getTimer(name);
    }
}

