/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate.collector;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Counter;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Histogram;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Timer;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Collector;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Context;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.CollectorAdapter;
import org.apache.beam.sdk.transforms.DoFn;
import org.checkerframework.checker.nullness.qual.Nullable;

@NotThreadSafe
public class AdaptableCollector<InputT, OutputT, ElemT>
implements Collector<ElemT>,
Context,
Serializable {
    private static final String UNSUPPORTED = "Accumulators are supported for named operators only.";
    private final AccumulatorProvider accumulators;
    private final CollectorAdapter<InputT, OutputT, ElemT> adapter;
    private final @Nullable String operatorName;
    private transient DoFn.ProcessContext context;

    public AdaptableCollector(AccumulatorProvider accumulators, @Nullable String operatorName, CollectorAdapter<InputT, OutputT, ElemT> adapter) {
        this.accumulators = accumulators;
        this.operatorName = operatorName;
        this.adapter = adapter;
    }

    @Override
    public void collect(ElemT elem) {
        this.adapter.collect(Objects.requireNonNull(this.context), elem);
    }

    @Override
    public Context asContext() {
        return this;
    }

    @Override
    public Counter getCounter(String name) {
        return this.accumulators.getCounter(Objects.requireNonNull(this.operatorName, UNSUPPORTED), name);
    }

    @Override
    public Histogram getHistogram(String name) {
        return this.accumulators.getHistogram(Objects.requireNonNull(this.operatorName, UNSUPPORTED), name);
    }

    @Override
    public Timer getTimer(String name) {
        throw new UnsupportedOperationException("Timer not supported. Use histogram instead.");
    }

    public void setProcessContext(DoFn.ProcessContext context) {
        this.context = Objects.requireNonNull(context);
    }
}

