/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TimestampExtractTransform<InputT, OutputT>
extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
    private final PCollectionTransform<InputT, OutputT> timestampedTransform;

    public static <InputT, OutputT> TimestampExtractTransform<InputT, OutputT> of(PCollectionTransform<InputT, OutputT> transform) {
        return new TimestampExtractTransform<InputT, OutputT>(null, transform);
    }

    public static <InputT, OutputT> TimestampExtractTransform<InputT, OutputT> of(String name, PCollectionTransform<InputT, OutputT> transform) {
        return new TimestampExtractTransform<InputT, OutputT>(name, transform);
    }

    private TimestampExtractTransform(@Nullable String name, PCollectionTransform<InputT, OutputT> timestampedTransform) {
        super(name);
        this.timestampedTransform = timestampedTransform;
    }

    public PCollection<OutputT> expand(PCollection<InputT> input) {
        PCollection in = (PCollection)input.apply(this.getName("wrap"), (PTransform)ParDo.of(new Wrap()));
        if (input.getTypeDescriptor() != null) {
            in = in.setTypeDescriptor(TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.longs(), (TypeDescriptor)input.getTypeDescriptor()));
        }
        return (PCollection)this.timestampedTransform.apply(in);
    }

    private String getName(String suffix) {
        return this.name != null ? this.name + "::" + suffix : suffix;
    }

    private static class Wrap<T>
    extends DoFn<T, KV<Long, T>> {
        private Wrap() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext ctx) {
            ctx.output((Object)KV.of((Object)ctx.timestamp().getMillis(), (Object)ctx.element()));
        }
    }

    @FunctionalInterface
    public static interface PCollectionTransform<InputT, OutputT>
    extends UnaryFunction<PCollection<KV<Long, InputT>>, PCollection<OutputT>> {
    }
}

