/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;

class ExtractKey<KeyT, ValueT>
extends PTransform<PCollection<ValueT>, PCollection<KV<KeyT, ValueT>>> {
    private final UnaryFunction<ValueT, KeyT> keyExtractor;
    private final TypeDescriptor<KeyT> keyType;

    ExtractKey(UnaryFunction<ValueT, KeyT> keyExtractor, TypeDescriptor<KeyT> keyType) {
        this.keyExtractor = Objects.requireNonNull(keyExtractor);
        this.keyType = Objects.requireNonNull(keyType);
    }

    public PCollection<KV<KeyT, ValueT>> expand(PCollection<ValueT> input) {
        Objects.requireNonNull(input.getTypeDescriptor());
        return ((PCollection)input.apply((PTransform)ParDo.of(new ExtractKeyFn<KeyT, ValueT>(this.keyExtractor)))).setTypeDescriptor(TypeDescriptors.kvs(this.keyType, (TypeDescriptor)input.getTypeDescriptor()));
    }

    private static class ExtractKeyFn<KeyT, InputT>
    extends DoFn<InputT, KV<KeyT, InputT>> {
        private final UnaryFunction<InputT, KeyT> keyExtractor;

        ExtractKeyFn(UnaryFunction<InputT, KeyT> keyExtractor) {
            this.keyExtractor = keyExtractor;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Object element = c.element();
            KeyT key = this.keyExtractor.apply(element);
            c.output((Object)KV.of(key, (Object)element));
        }
    }
}

