/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Join;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.translate.ExtractKey;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTranslator;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

abstract class AbstractJoinTranslator<LeftT, RightT, KeyT, OutputT>
implements OperatorTranslator<Object, KV<KeyT, OutputT>, Join<LeftT, RightT, KeyT, OutputT>> {
    AbstractJoinTranslator() {
    }

    @Override
    public PCollection<KV<KeyT, OutputT>> translate(Join<LeftT, RightT, KeyT, OutputT> operator, PCollectionList<Object> inputs) {
        Preconditions.checkArgument((inputs.size() == 2 ? 1 : 0) != 0, (Object)"Join expects exactly two inputs.");
        PCollection left = inputs.get(0);
        PCollection right = inputs.get(1);
        PCollection leftKeyed = (PCollection)left.apply("extract-keys-left", new ExtractKey<KeyT, LeftT>(operator.getLeftKeyExtractor(), TypeAwareness.orObjects(operator.getKeyType())));
        PCollection rightKeyed = (PCollection)right.apply("extract-keys-right", new ExtractKey<KeyT, RightT>(operator.getRightKeyExtractor(), TypeAwareness.orObjects(operator.getKeyType())));
        if (operator.getWindow().isPresent()) {
            Window leftWindow = operator.getWindow().get();
            leftKeyed = (PCollection)leftKeyed.apply("window-left", leftWindow);
            Window rightWindow = operator.getWindow().get();
            rightKeyed = (PCollection)rightKeyed.apply("window-right", rightWindow);
        }
        return this.translate(operator, left, leftKeyed, right, rightKeyed).setTypeDescriptor(operator.getOutputType().orElseThrow(() -> new IllegalStateException("Unable to infer output type descriptor.")));
    }

    abstract PCollection<KV<KeyT, OutputT>> translate(Join<LeftT, RightT, KeyT, OutputT> var1, PCollection<LeftT> var2, PCollection<KV<KeyT, LeftT>> var3, PCollection<RightT> var4, PCollection<KV<KeyT, RightT>> var5);
}

