/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.util;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Triple<T1, T2, T3> {
    final T1 first;
    final T2 second;
    final T3 third;

    private Triple(T1 first, T2 second, T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <T1, T2, T3> Triple<T1, T2, T3> of(T1 first, T2 second, T3 third) {
        return new Triple<T1, T2, T3>(first, second, third);
    }

    public T1 getFirst() {
        return this.first;
    }

    public T2 getSecond() {
        return this.second;
    }

    public T3 getThird() {
        return this.third;
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof Triple) {
            Triple triple = (Triple)o;
            return Objects.equals(this.first, triple.first) && Objects.equals(this.second, triple.second) && Objects.equals(this.third, triple.third);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public String toString() {
        return "Triple{first=" + this.first + ", second=" + this.second + ", third=" + this.third + '}';
    }
}

