/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.util;

import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;

public class Sums {
    private static final SumFunction<Long> SUMS_OF_LONG = new SumFunction<Long>(0L, TypeDescriptors.longs(), (a, b) -> a + b);
    private static final SumFunction<Integer> SUMS_OF_INT = new SumFunction<Integer>(0, TypeDescriptors.integers(), (a, b) -> a + b);
    private static final SumFunction<Float> SUMS_OF_FLOAT = new SumFunction<Float>(Float.valueOf(0.0f), TypeDescriptors.floats(), (a, b) -> Float.valueOf(a.floatValue() + b.floatValue()));
    private static final SumFunction<Double> SUMS_OF_DOUBLE = new SumFunction<Double>(0.0, TypeDescriptors.doubles(), (a, b) -> a + b);

    private Sums() {
    }

    public static ReduceByKey.CombineFunctionWithIdentity<Long> ofLongs() {
        return SUMS_OF_LONG;
    }

    public static ReduceByKey.CombineFunctionWithIdentity<Integer> ofInts() {
        return SUMS_OF_INT;
    }

    public static ReduceByKey.CombineFunctionWithIdentity<Float> ofFloats() {
        return SUMS_OF_FLOAT;
    }

    public static ReduceByKey.CombineFunctionWithIdentity<Double> ofDoubles() {
        return SUMS_OF_DOUBLE;
    }

    private static class SumFunction<T>
    implements ReduceByKey.CombineFunctionWithIdentity<T> {
        private final T identity;
        private final TypeDescriptor<T> valueDesc;
        private final BinaryFunction<T, T, T> reduce;

        SumFunction(T identity, TypeDescriptor<T> valueDesc, BinaryFunction<T, T, T> reduce) {
            this.identity = identity;
            this.valueDesc = valueDesc;
            this.reduce = reduce;
        }

        @Override
        public T identity() {
            return this.identity;
        }

        @Override
        public TypeDescriptor<T> valueDesc() {
            return this.valueDesc;
        }

        @Override
        public T apply(T left, T right) {
            return this.reduce.apply(left, right);
        }
    }
}

