/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.util;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.translate.SingleValueContext;

public class Fold
implements Serializable {
    public static <T> CombinableReduceFunction<T> of(BinaryFunction<T, T, T> fold) {
        return s -> s.reduce(fold::apply).orElseThrow(() -> new IllegalStateException("Received empty stream on input!"));
    }

    public static <T> CombinableReduceFunction<T> of(T identity, BinaryFunction<T, T, T> fold) {
        return s -> s.reduce(identity, fold::apply);
    }

    public static <T> ReduceFunctor<T, T> of(T identity, BinaryFunctor<T, T, T> fold) {
        return (s, ctx) -> {
            SingleValueContext wrap = new SingleValueContext(ctx.asContext());
            Object ret = s.reduce(identity, (a, b) -> {
                fold.apply(a, b, wrap);
                return wrap.getAndResetValue();
            });
            ctx.collect(ret);
        };
    }
}

