/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.type;

import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.Triple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeUtils {
    public static <K, V> @Nullable TypeDescriptor<KV<K, V>> keyValues(TypeDescriptor<K> key, TypeDescriptor<V> value) {
        if (Objects.isNull(key) || Objects.isNull(value)) {
            return null;
        }
        return new TypeDescriptor<KV<K, V>>(){}.where(new TypeParameter<K>(){}, key).where(new TypeParameter<V>(){}, value);
    }

    public static <K, V> @Nullable TypeDescriptor<KV<K, V>> keyValues(Class<K> key, Class<V> value) {
        if (Objects.isNull(key) || Objects.isNull(value)) {
            return null;
        }
        return TypeUtils.keyValues(TypeDescriptor.of(key), TypeDescriptor.of(value));
    }

    public static <K, V, ScoreT> TypeDescriptor<Triple<K, V, ScoreT>> triplets(TypeDescriptor<K> key, TypeDescriptor<V> value, TypeDescriptor<ScoreT> score) {
        if (Objects.isNull(key) || Objects.isNull(value) || Objects.isNull(score)) {
            return null;
        }
        return new TypeDescriptor<Triple<K, V, ScoreT>>(){}.where(new TypeParameter<K>(){}, key).where(new TypeParameter<V>(){}, value).where(new TypeParameter<ScoreT>(){}, score);
    }
}

