/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator.base;

import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.WindowAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ShuffleOperator<InputT, KeyT, OutputT>
extends Operator<OutputT>
implements TypeAware.Key<KeyT>,
WindowAware<InputT> {
    private final UnaryFunction<InputT, KeyT> keyExtractor;
    private final @Nullable TypeDescriptor<KeyT> keyType;
    private final @Nullable Window<InputT> window;

    protected ShuffleOperator(@Nullable String name, @Nullable TypeDescriptor<OutputT> outputType, UnaryFunction<InputT, KeyT> keyExtractor, @Nullable TypeDescriptor<KeyT> keyType, @Nullable Window<InputT> windowing) {
        super(name, outputType);
        this.keyExtractor = keyExtractor;
        this.keyType = keyType;
        this.window = windowing;
    }

    public UnaryFunction<InputT, KeyT> getKeyExtractor() {
        return this.keyExtractor;
    }

    @Override
    public Optional<TypeDescriptor<KeyT>> getKeyType() {
        return Optional.ofNullable(this.keyType);
    }

    @Override
    public Optional<Window<InputT>> getWindow() {
        return Optional.ofNullable(this.window);
    }
}

