/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

class WindowBuilder<T>
implements Builders.WindowBy<WindowBuilder<T>>,
Builders.TriggeredBy<WindowBuilder<T>>,
Builders.AccumulationMode<WindowBuilder<T>>,
Builders.WindowedOutput<WindowBuilder<T>> {
    private @Nullable Window<T> window;

    WindowBuilder() {
    }

    Optional<Window<T>> getWindow() {
        return Optional.ofNullable(this.window);
    }

    void setWindow(Window<T> window) {
        Preconditions.checkState((this.window == null ? 1 : 0) != 0, (Object)"Window is already set.");
        this.window = window;
    }

    @Override
    public <W extends BoundedWindow> WindowBuilder<T> windowBy(WindowFn<Object, W> windowFn) {
        Preconditions.checkState((this.window == null ? 1 : 0) != 0, (Object)"Window is already set.");
        this.window = Window.into(windowFn);
        return this;
    }

    @Override
    public WindowBuilder<T> triggeredBy(Trigger trigger) {
        this.window = Objects.requireNonNull(this.window).triggering(trigger);
        return this;
    }

    @Override
    public WindowBuilder<T> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
        switch (Objects.requireNonNull(accumulationMode)) {
            case DISCARDING_FIRED_PANES: {
                this.window = Objects.requireNonNull(this.window).discardingFiredPanes();
                break;
            }
            case ACCUMULATING_FIRED_PANES: {
                this.window = Objects.requireNonNull(this.window).accumulatingFiredPanes();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown accumulation mode [" + accumulationMode + "]");
            }
        }
        return this;
    }

    @Override
    public WindowBuilder<T> withAllowedLateness(Duration allowedLateness) {
        this.window = Objects.requireNonNull(this.window).withAllowedLateness(Objects.requireNonNull(allowedLateness));
        return this;
    }

    @Override
    public WindowBuilder<T> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
        this.window = Objects.requireNonNull(this.window).withAllowedLateness(Objects.requireNonNull(allowedLateness), Objects.requireNonNull(closingBehavior));
        return this;
    }

    @Override
    public WindowBuilder<T> withTimestampCombiner(TimestampCombiner timestampCombiner) {
        this.window = Objects.requireNonNull(this.window).withTimestampCombiner(Objects.requireNonNull(timestampCombiner));
        return this;
    }

    @Override
    public WindowBuilder<T> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
        this.window = Objects.requireNonNull(this.window).withOnTimeBehavior(Objects.requireNonNull(behavior));
        return this;
    }
}

