/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Basic;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Basic(state=StateComplexity.ZERO, repartitions=0)
public class Union<InputT>
extends Operator<InputT> {
    @SafeVarargs
    public static <InputT> Builders.Output<InputT> of(PCollection<InputT> ... pCollections) {
        return Union.of(Arrays.asList(pCollections));
    }

    public static <InputT> Builders.Output<InputT> of(List<PCollection<InputT>> pCollections) {
        return Union.named(null).of(pCollections);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private Union(@Nullable String name, @Nullable TypeDescriptor<InputT> outputType) {
        super(name, outputType);
    }

    private static class Builder<InputT>
    extends OfBuilder
    implements Builders.Output<InputT> {
        private final @Nullable String name;
        private List<PCollection<InputT>> pCollections;

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> Builders.Output<T> of(List<PCollection<T>> pCollections) {
            Builder cast = this;
            cast.pCollections = pCollections;
            return cast;
        }

        @Override
        public PCollection<InputT> output() {
            Preconditions.checkArgument((this.pCollections.size() > 1 ? 1 : 0) != 0, (Object)"Union needs at least two data sets.");
            return OperatorTransform.apply(new Union(this.name, this.pCollections.get(0).getTypeDescriptor()), PCollectionList.of(this.pCollections));
        }
    }

    public static abstract class OfBuilder {
        @SafeVarargs
        public final <InputT> Builders.Output<InputT> of(PCollection<InputT> ... pCollections) {
            return this.of(Arrays.asList(pCollections));
        }

        public abstract <InputT> Builders.Output<InputT> of(List<PCollection<InputT>> var1);
    }
}

