/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.MapElements;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeUtils;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.Triple;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Derived(state=StateComplexity.CONSTANT, repartitions=1)
public class TopPerKey<InputT, KeyT, ValueT, ScoreT extends Comparable<ScoreT>>
extends ShuffleOperator<InputT, KeyT, Triple<KeyT, ValueT, ScoreT>>
implements TypeAware.Value<ValueT>,
CompositeOperator<InputT, Triple<KeyT, ValueT, ScoreT>> {
    private UnaryFunction<InputT, ValueT> valueExtractor;
    private @Nullable TypeDescriptor<ValueT> valueType;
    private UnaryFunction<InputT, ScoreT> scoreExtractor;
    private @Nullable TypeDescriptor<ScoreT> scoreType;

    public static <InputT> KeyByBuilder<InputT> of(PCollection<InputT> input) {
        return TopPerKey.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private TopPerKey(@Nullable String name, UnaryFunction<InputT, KeyT> keyExtractor, @Nullable TypeDescriptor<KeyT> keyType, UnaryFunction<InputT, ValueT> valueExtractor, @Nullable TypeDescriptor<ValueT> valueType, UnaryFunction<InputT, ScoreT> scoreExtractor, @Nullable TypeDescriptor<ScoreT> scoreType, @Nullable Window<InputT> window, @Nullable TypeDescriptor<Triple<KeyT, ValueT, ScoreT>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
        this.valueExtractor = valueExtractor;
        this.valueType = valueType;
        this.scoreExtractor = scoreExtractor;
        this.scoreType = scoreType;
    }

    public UnaryFunction<InputT, ValueT> getValueExtractor() {
        return this.valueExtractor;
    }

    @Override
    public Optional<TypeDescriptor<ValueT>> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    public UnaryFunction<InputT, ScoreT> getScoreExtractor() {
        return this.scoreExtractor;
    }

    public Optional<TypeDescriptor<ScoreT>> getScoreType() {
        return Optional.ofNullable(this.scoreType);
    }

    @Override
    public PCollection<Triple<KeyT, ValueT, ScoreT>> expand(PCollectionList<InputT> inputs) {
        PCollection<Triple> extracted = MapElements.named("extract-key-value-score").of((PCollection)PCollectionLists.getOnlyElement(inputs)).using(elem -> Triple.of(this.getKeyExtractor().apply(elem), this.getValueExtractor().apply(elem), (Comparable)this.getScoreExtractor().apply(elem)), (TypeDescriptor)this.getOutputType().orElse(null)).output();
        return ReduceByKey.named("combine-by-key").of((PCollection)extracted).keyBy(Triple::getFirst, (TypeDescriptor)this.getKeyType().orElse(null)).combineBy(triplets -> (Triple)triplets.reduce((a, b) -> ((Comparable)a.getThird()).compareTo((Comparable)b.getThird()) > 0 ? a : b).orElseThrow(IllegalStateException::new)).applyIf(this.getWindow().isPresent(), builder -> {
            ReduceByKey.WindowByInternalBuilder cast = (ReduceByKey.WindowByInternalBuilder)((Object)builder);
            return cast.windowBy(this.getWindow().orElseThrow(() -> new IllegalStateException("Unable to resolve windowing for TopPerKey expansion.")));
        }).outputValues();
    }

    private static class Builder<InputT, KeyT, ValueT, ScoreT extends Comparable<ScoreT>>
    implements OfBuilder,
    KeyByBuilder<InputT>,
    ValueByBuilder<InputT, KeyT>,
    ScoreBy<InputT, KeyT, ValueT>,
    WindowByBuilder<KeyT, ValueT, ScoreT>,
    TriggeredByBuilder<KeyT, ValueT, ScoreT>,
    AccumulationModeBuilder<KeyT, ValueT, ScoreT>,
    WindowedOutputBuilder<KeyT, ValueT, ScoreT>,
    OutputBuilder<KeyT, ValueT, ScoreT> {
        private final WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        private final @Nullable String name;
        private PCollection<InputT> input;
        private UnaryFunction<InputT, KeyT> keyExtractor;
        private @Nullable TypeDescriptor<KeyT> keyType;
        private UnaryFunction<InputT, ValueT> valueExtractor;
        private @Nullable TypeDescriptor<ValueT> valueType;
        private UnaryFunction<InputT, ScoreT> scoreExtractor;
        private @Nullable TypeDescriptor<ScoreT> scoreType;

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> KeyByBuilder<T> of(PCollection<T> input) {
            this.input = Objects.requireNonNull(input);
            return this;
        }

        @Override
        public <T> ValueByBuilder<InputT, T> keyBy(UnaryFunction<InputT, T> keyExtractor, @Nullable TypeDescriptor<T> keyType) {
            Builder cast = this;
            cast.keyExtractor = Objects.requireNonNull(keyExtractor);
            cast.keyType = keyType;
            return cast;
        }

        @Override
        public <T> ScoreBy<InputT, KeyT, T> valueBy(UnaryFunction<InputT, T> valueExtractor, @Nullable TypeDescriptor<T> valueType) {
            Builder cast = this;
            cast.valueExtractor = Objects.requireNonNull(valueExtractor);
            cast.valueType = valueType;
            return cast;
        }

        @Override
        public <T extends Comparable<T>> WindowByBuilder<KeyT, ValueT, T> scoreBy(UnaryFunction<InputT, T> scoreExtractor, @Nullable TypeDescriptor<T> scoreType) {
            Builder cast = this;
            cast.scoreExtractor = Objects.requireNonNull(scoreExtractor);
            cast.scoreType = scoreType;
            return cast;
        }

        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT, ValueT, ScoreT> windowBy(WindowFn<Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public AccumulationModeBuilder<KeyT, ValueT, ScoreT> triggeredBy(Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, ValueT, ScoreT> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, ValueT, ScoreT> withAllowedLateness(Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, ValueT, ScoreT> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, ValueT, ScoreT> withTimestampCombiner(TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, ValueT, ScoreT> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public PCollection<Triple<KeyT, ValueT, ScoreT>> output() {
            TopPerKey sbk = new TopPerKey(this.name, this.keyExtractor, this.keyType, this.valueExtractor, this.valueType, this.scoreExtractor, this.scoreType, this.windowBuilder.getWindow().orElse(null), TypeUtils.triplets(this.keyType, this.valueType, this.scoreType));
            return OperatorTransform.apply(sbk, PCollectionList.of(this.input));
        }
    }

    public static interface OutputBuilder<KeyT, ValueT, ScoreT extends Comparable<ScoreT>>
    extends Builders.Output<Triple<KeyT, ValueT, ScoreT>> {
    }

    public static interface WindowedOutputBuilder<KeyT, ValueT, ScoreT extends Comparable<ScoreT>>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT, ValueT, ScoreT>>,
    OutputBuilder<KeyT, ValueT, ScoreT> {
    }

    public static interface AccumulationModeBuilder<KeyT, ValueT, ScoreT extends Comparable<ScoreT>>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT, ValueT, ScoreT>> {
        @Override
        public WindowedOutputBuilder<KeyT, ValueT, ScoreT> accumulationMode(WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<KeyT, ValueT, ScoreT extends Comparable<ScoreT>>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT, ValueT, ScoreT>> {
        @Override
        public AccumulationModeBuilder<KeyT, ValueT, ScoreT> triggeredBy(Trigger var1);
    }

    public static interface WindowByBuilder<KeyT, ValueT, ScoreT extends Comparable<ScoreT>>
    extends Builders.WindowBy<TriggeredByBuilder<KeyT, ValueT, ScoreT>>,
    OptionalMethodBuilder<WindowByBuilder<KeyT, ValueT, ScoreT>, OutputBuilder<KeyT, ValueT, ScoreT>>,
    OutputBuilder<KeyT, ValueT, ScoreT> {
        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT, ValueT, ScoreT> windowBy(WindowFn<Object, W> var1);

        @Override
        default public OutputBuilder<KeyT, ValueT, ScoreT> applyIf(boolean cond, UnaryFunction<WindowByBuilder<KeyT, ValueT, ScoreT>, OutputBuilder<KeyT, ValueT, ScoreT>> fn) {
            return cond ? Objects.requireNonNull(fn).apply(this) : this;
        }
    }

    public static interface ScoreBy<InputT, KeyT, ValueT> {
        default public <ScoreT extends Comparable<ScoreT>> WindowByBuilder<KeyT, ValueT, ScoreT> scoreBy(UnaryFunction<InputT, ScoreT> scoreFn) {
            return this.scoreBy(scoreFn, null);
        }

        public <ScoreT extends Comparable<ScoreT>> WindowByBuilder<KeyT, ValueT, ScoreT> scoreBy(UnaryFunction<InputT, ScoreT> var1, @Nullable TypeDescriptor<ScoreT> var2);
    }

    public static interface ValueByBuilder<InputT, KeyT> {
        default public <ValueT> ScoreBy<InputT, KeyT, ValueT> valueBy(UnaryFunction<InputT, ValueT> valueExtractor) {
            return this.valueBy(valueExtractor, null);
        }

        public <ValueT> ScoreBy<InputT, KeyT, ValueT> valueBy(UnaryFunction<InputT, ValueT> var1, @Nullable TypeDescriptor<ValueT> var2);
    }

    public static interface KeyByBuilder<InputT>
    extends Builders.KeyBy<InputT> {
        public <T> ValueByBuilder<InputT, T> keyBy(UnaryFunction<InputT, T> var1, TypeDescriptor<T> var2);

        default public <T> ValueByBuilder<InputT, T> keyBy(UnaryFunction<InputT, T> keyExtractor) {
            return this.keyBy((UnaryFunction)keyExtractor, (TypeDescriptor)null);
        }
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> KeyByBuilder<InputT> of(PCollection<InputT> var1);
    }
}

