/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableBinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.VoidFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Derived(state=StateComplexity.CONSTANT_IF_COMBINABLE, repartitions=1)
public class ReduceWindow<InputT, ValueT, AccT, OutputT>
extends ShuffleOperator<InputT, Byte, OutputT>
implements TypeAware.Value<ValueT>,
CompositeOperator<InputT, OutputT> {
    private static final Byte B_ZERO = 0;
    private final @Nullable ReduceFunctor<ValueT, OutputT> reducer;
    private final @Nullable VoidFunction<AccT> accumulatorFactory;
    private final @Nullable BinaryFunction<AccT, ValueT, AccT> accumulate;
    private final @Nullable CombinableBinaryFunction<AccT> mergeAccumulators;
    private final @Nullable UnaryFunction<AccT, OutputT> outputFn;
    private final @Nullable TypeDescriptor<AccT> accumulatorType;
    private final UnaryFunction<InputT, ValueT> valueExtractor;
    private final @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator;
    private final @Nullable TypeDescriptor<ValueT> valueType;

    public static <InputT> ValueByReduceByBuilder<InputT, InputT> of(PCollection<InputT> input) {
        return ReduceWindow.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private ReduceWindow(@Nullable String name, UnaryFunction<InputT, ValueT> valueExtractor, @Nullable TypeDescriptor<ValueT> valueType, ReduceFunctor<ValueT, OutputT> reducer, @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator, @Nullable Window<InputT> window, TypeDescriptor<OutputT> outputType) {
        super(name, outputType, e -> B_ZERO, TypeDescriptors.bytes(), window);
        this.reducer = Objects.requireNonNull(reducer);
        this.valueExtractor = valueExtractor;
        this.valueType = valueType;
        this.valueComparator = valueComparator;
        this.accumulatorFactory = null;
        this.accumulate = null;
        this.mergeAccumulators = null;
        this.outputFn = null;
        this.accumulatorType = null;
    }

    private ReduceWindow(@Nullable String name, UnaryFunction<InputT, ValueT> valueExtractor, @Nullable TypeDescriptor<ValueT> valueType, VoidFunction<AccT> accumulatorFactory, BinaryFunction<AccT, ValueT, AccT> accumulate, CombinableBinaryFunction<AccT> mergeAccumulators, UnaryFunction<AccT, OutputT> outputFn, @Nullable TypeDescriptor<AccT> accumulatorType, @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator, @Nullable Window<InputT> window, TypeDescriptor<OutputT> outputType) {
        super(name, outputType, e -> B_ZERO, TypeDescriptors.bytes(), window);
        this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory);
        this.accumulate = Objects.requireNonNull(accumulate);
        this.mergeAccumulators = Objects.requireNonNull(mergeAccumulators);
        this.outputFn = Objects.requireNonNull(outputFn);
        this.accumulatorType = accumulatorType;
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
        this.valueType = valueType;
        this.valueComparator = valueComparator;
        this.reducer = null;
    }

    public boolean isCombineFnStyle() {
        return this.reducer == null;
    }

    public ReduceFunctor<ValueT, OutputT> getReducer() {
        return Objects.requireNonNull(this.reducer, "Don't call #getReducer is #isCombineFnStyle() == true");
    }

    public boolean isCombinable() {
        return this.isCombineFnStyle() || this.reducer.isCombinable();
    }

    public UnaryFunction<InputT, ValueT> getValueExtractor() {
        return this.valueExtractor;
    }

    public Optional<BinaryFunction<ValueT, ValueT, Integer>> getValueComparator() {
        return Optional.ofNullable(this.valueComparator);
    }

    @Override
    public Optional<TypeDescriptor<ValueT>> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    @Override
    public PCollection<OutputT> expand(PCollectionList<InputT> inputs) {
        ReduceByKey.WindowByBuilder windowBy;
        if (this.isCombinable()) {
            Preconditions.checkState((this.valueComparator == null ? 1 : 0) != 0, (Object)"Sorting is not supported for combinable reducers.");
        }
        if (this.isCombineFnStyle()) {
            windowBy = ReduceByKey.named(this.getName().orElse("") + "::reduce-by").of((PCollection)PCollectionLists.getOnlyElement(inputs)).keyBy(this.getKeyExtractor()).valueBy(this.valueExtractor, this.valueType).combineBy(this.accumulatorFactory, this.accumulate, this.mergeAccumulators, this.outputFn, this.accumulatorType, this.getOutputType().orElse(null));
        } else {
            ReduceByKey.WithSortedValuesBuilder reduceBy = ReduceByKey.named(this.getName().orElse("") + "::reduce-by").of((PCollection)PCollectionLists.getOnlyElement(inputs)).keyBy(this.getKeyExtractor()).valueBy(this.valueExtractor, this.valueType).reduceBy(this.reducer, (TypeDescriptor)this.getOutputType().orElse(null));
            windowBy = this.getValueComparator().isPresent() ? reduceBy.withSortedValues(this.valueComparator) : reduceBy;
        }
        return windowBy.applyIf(this.getWindow().isPresent(), builder -> {
            ReduceByKey.WindowByInternalBuilder cast = (ReduceByKey.WindowByInternalBuilder)((Object)builder);
            return cast.windowBy(this.getWindow().orElseThrow(() -> new IllegalStateException("Unable to resolve windowing for ReduceWindow expansion.")));
        }).outputValues();
    }

    private static class Builder<InputT, ValueT, AccT, OutputT>
    implements OfBuilder,
    ValueByReduceByBuilder<InputT, ValueT>,
    WithSortedValuesBuilder<ValueT, OutputT>,
    WindowByBuilder<OutputT>,
    TriggeredByBuilder<OutputT>,
    AccumulationModeBuilder<OutputT>,
    WindowedOutputBuilder<OutputT>,
    Builders.Output<OutputT> {
        private final WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        private final @Nullable String name;
        private final @Nullable ReduceFunctor<ValueT, OutputT> reducer;
        private final @Nullable VoidFunction<AccT> accumulatorFactory;
        private final @Nullable BinaryFunction<AccT, ValueT, AccT> accumulate;
        private final @Nullable CombinableBinaryFunction<AccT> mergeAccumulators;
        private final @Nullable UnaryFunction<AccT, OutputT> outputFn;
        private final @Nullable TypeDescriptor<AccT> accumulatorType;
        private PCollection<InputT> input;
        private @Nullable UnaryFunction<InputT, ValueT> valueExtractor;
        private @Nullable TypeDescriptor<ValueT> valueType;
        private @Nullable TypeDescriptor<OutputT> outputType;
        private @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator;

        Builder(@Nullable String name) {
            this.name = name;
            this.reducer = null;
            this.accumulatorFactory = null;
            this.accumulate = null;
            this.mergeAccumulators = null;
            this.outputFn = null;
            this.accumulatorType = null;
        }

        private Builder(Builder parent, ReduceFunctor<ValueT, OutputT> reducer) {
            this.name = parent.name;
            this.reducer = Objects.requireNonNull(reducer);
            this.accumulatorFactory = null;
            this.accumulate = null;
            this.mergeAccumulators = null;
            this.outputFn = null;
            this.accumulatorType = null;
            this.input = parent.input;
            this.valueExtractor = parent.valueExtractor;
            this.valueType = parent.valueType;
            this.outputType = parent.outputType;
            this.valueComparator = parent.valueComparator;
        }

        private Builder(Builder parent, VoidFunction<AccT> accumulatorFactory, BinaryFunction<AccT, ValueT, AccT> accumulate, CombinableBinaryFunction<AccT> mergeAccumulators, UnaryFunction<AccT, OutputT> outputFn, TypeDescriptor<AccT> accumulatorType) {
            this.name = parent.name;
            this.reducer = null;
            this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory);
            this.accumulate = Objects.requireNonNull(accumulate);
            this.mergeAccumulators = Objects.requireNonNull(mergeAccumulators);
            this.outputFn = Objects.requireNonNull(outputFn);
            this.accumulatorType = accumulatorType;
            this.input = parent.input;
            this.valueExtractor = parent.valueExtractor;
            this.valueType = parent.valueType;
            this.outputType = parent.outputType;
            this.valueComparator = parent.valueComparator;
        }

        public <T> ValueByReduceByBuilder<T, T> of(PCollection<T> input) {
            Builder cast = this;
            cast.input = Objects.requireNonNull(input);
            return cast;
        }

        @Override
        public <T> ReduceByBuilder<T> valueBy(UnaryFunction<InputT, T> valueExtractor, @Nullable TypeDescriptor<T> valueType) {
            Builder cast = this;
            cast.valueExtractor = Objects.requireNonNull(valueExtractor);
            cast.valueType = valueType;
            return cast;
        }

        @Override
        public <T> WithSortedValuesBuilder<ValueT, T> reduceBy(ReduceFunctor<ValueT, T> reducer, @Nullable TypeDescriptor<T> outputType) {
            Builder<InputT, ValueT, AccT, T> cast = new Builder<InputT, ValueT, AccT, T>(this, reducer);
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public <NewAccT, T> WindowByBuilder<T> combineBy(VoidFunction<NewAccT> accumulatorFactory, BinaryFunction<NewAccT, ValueT, NewAccT> accumulate, CombinableBinaryFunction<NewAccT> mergeAccumulators, UnaryFunction<NewAccT, T> outputFn, @Nullable TypeDescriptor<NewAccT> accumulatorDescriptor, @Nullable TypeDescriptor<T> outputDescriptor) {
            Builder<InputT, ValueT, NewAccT, T> ret = new Builder<InputT, ValueT, NewAccT, T>(this, accumulatorFactory, accumulate, mergeAccumulators, outputFn, accumulatorDescriptor);
            ret.valueType = this.valueType;
            ret.outputType = outputDescriptor;
            return ret;
        }

        @Override
        public WindowByBuilder<OutputT> withSortedValues(BinaryFunction<ValueT, ValueT, Integer> valueComparator) {
            this.valueComparator = Objects.requireNonNull(valueComparator);
            return this;
        }

        @Override
        public <T extends BoundedWindow> TriggeredByBuilder<OutputT> windowBy(WindowFn<Object, T> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public AccumulationModeBuilder<OutputT> triggeredBy(Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withAllowedLateness(Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withTimestampCombiner(TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public PCollection<OutputT> output() {
            if (this.valueExtractor == null) {
                this.valueExtractor = this.identity();
            }
            ReduceWindow rw = this.reducer != null ? new ReduceWindow(this.name, this.valueExtractor, this.valueType, this.reducer, this.valueComparator, this.windowBuilder.getWindow().orElse(null), this.outputType) : new ReduceWindow(this.name, this.valueExtractor, this.valueType, this.accumulatorFactory, this.accumulate, this.mergeAccumulators, this.outputFn, this.accumulatorType, this.valueComparator, this.windowBuilder.getWindow().orElse(null), this.outputType);
            return OperatorTransform.apply(rw, PCollectionList.of(this.input));
        }

        private UnaryFunction<InputT, ValueT> identity() {
            return UnaryFunction.identity();
        }
    }

    public static interface WindowedOutputBuilder<OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<OutputT>>,
    Builders.Output<OutputT> {
    }

    public static interface AccumulationModeBuilder<OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<OutputT>> {
        @Override
        public WindowedOutputBuilder<OutputT> accumulationMode(WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<OutputT>> {
        @Override
        public AccumulationModeBuilder<OutputT> triggeredBy(Trigger var1);
    }

    public static interface WindowByBuilder<OutputT>
    extends Builders.WindowBy<TriggeredByBuilder<OutputT>>,
    OptionalMethodBuilder<WindowByBuilder<OutputT>, Builders.Output<OutputT>>,
    Builders.Output<OutputT> {
        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<OutputT> windowBy(WindowFn<Object, W> var1);

        @Override
        default public Builders.Output<OutputT> applyIf(boolean cond, UnaryFunction<WindowByBuilder<OutputT>, Builders.Output<OutputT>> fn) {
            Objects.requireNonNull(fn);
            return cond ? fn.apply(this) : this;
        }
    }

    public static interface WithSortedValuesBuilder<ValueT, OutputT>
    extends WindowByBuilder<OutputT> {
        public WindowByBuilder<OutputT> withSortedValues(BinaryFunction<ValueT, ValueT, Integer> var1);
    }

    public static interface ValueByReduceByBuilder<InputT, ValueT>
    extends ReduceByBuilder<ValueT> {
        public <T> ReduceByBuilder<T> valueBy(UnaryFunction<InputT, T> var1, @Nullable TypeDescriptor<T> var2);

        default public <T> ReduceByBuilder<T> valueBy(UnaryFunction<InputT, T> valueExtractor) {
            return this.valueBy(valueExtractor, null);
        }
    }

    public static interface ReduceByBuilder<ValueT> {
        default public <OutputT> WithSortedValuesBuilder<ValueT, OutputT> reduceBy(ReduceFunction<ValueT, OutputT> reducer) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)));
        }

        default public <OutputT> WithSortedValuesBuilder<ValueT, OutputT> reduceBy(ReduceFunction<ValueT, OutputT> reducer, TypeDescriptor<OutputT> outputType) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)), outputType);
        }

        default public <OutputT> WithSortedValuesBuilder<ValueT, OutputT> reduceBy(ReduceFunctor<ValueT, OutputT> reducer) {
            return this.reduceBy(reducer, null);
        }

        public <OutputT> WithSortedValuesBuilder<ValueT, OutputT> reduceBy(ReduceFunctor<ValueT, OutputT> var1, @Nullable TypeDescriptor<OutputT> var2);

        default public WindowByBuilder<ValueT> combineBy(CombinableReduceFunction<ValueT> reducer) {
            return this.reduceBy(ReduceFunctor.of(reducer));
        }

        default public WindowByBuilder<ValueT> combineBy(CombinableReduceFunction<ValueT> reducer, TypeDescriptor<ValueT> outputType) {
            return this.reduceBy(ReduceFunctor.of(reducer), outputType);
        }

        default public WindowByBuilder<ValueT> combineBy(ReduceByKey.CombineFunctionWithIdentity<ValueT> reduce) {
            return this.combineBy(reduce.identity(), reduce, reduce.valueDesc());
        }

        @Deprecated
        default public WindowByBuilder<ValueT> combineBy(ReduceByKey.CombineFunctionWithIdentity<ValueT> reduce, TypeDescriptor<ValueT> ignored) {
            return this.combineBy(reduce.identity(), reduce, reduce.valueDesc());
        }

        default public WindowByBuilder<ValueT> combineBy(ValueT identity, CombinableBinaryFunction<ValueT> reducer) {
            return this.combineBy(identity, reducer, null);
        }

        default public WindowByBuilder<ValueT> combineBy(ValueT identity, CombinableBinaryFunction<ValueT> reducer, @Nullable TypeDescriptor<ValueT> valueType) {
            return this.combineBy(() -> identity, reducer, reducer, e -> e, valueType, valueType);
        }

        default public <AccT> WindowByBuilder<ValueT> combineBy(VoidFunction<AccT> accumulatorFactory, BinaryFunction<AccT, ValueT, AccT> accumulate, CombinableBinaryFunction<AccT> mergeAccumulators, UnaryFunction<AccT, ValueT> outputFn) {
            return this.combineBy(accumulatorFactory, accumulate, mergeAccumulators, outputFn, null, null);
        }

        public <AccT, OutputT> WindowByBuilder<OutputT> combineBy(VoidFunction<AccT> var1, BinaryFunction<AccT, ValueT, AccT> var2, CombinableBinaryFunction<AccT> var3, UnaryFunction<AccT, OutputT> var4, @Nullable TypeDescriptor<AccT> var5, @Nullable TypeDescriptor<OutputT> var6);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> ValueByReduceByBuilder<InputT, InputT> of(PCollection<InputT> var1);
    }
}

