/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Recommended;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableBinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.VoidFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.OutputValues;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Recommended(reason="Is very recommended to override because of performance in a specific area of (mostly) batch calculations where combiners can be efficiently used in the executor-specific implementation", state=StateComplexity.CONSTANT_IF_COMBINABLE, repartitions=1)
public class ReduceByKey<InputT, KeyT, ValueT, AccT, OutputT>
extends ShuffleOperator<InputT, KeyT, KV<KeyT, OutputT>>
implements TypeAware.Value<ValueT> {
    private final @Nullable ReduceFunctor<ValueT, OutputT> reducer;
    private final @Nullable VoidFunction<AccT> accumulatorFactory;
    private final @Nullable BinaryFunction<AccT, ValueT, AccT> accumulate;
    private final @Nullable CombinableBinaryFunction<AccT> mergeAccumulators;
    private final @Nullable UnaryFunction<AccT, OutputT> outputFn;
    private final @Nullable TypeDescriptor<AccT> accumulatorType;
    private final UnaryFunction<InputT, ValueT> valueExtractor;
    private final @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator;
    private final @Nullable TypeDescriptor<ValueT> valueType;

    public static <InputT> KeyByBuilder<InputT> of(PCollection<InputT> input) {
        return ReduceByKey.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private ReduceByKey(@Nullable String name, UnaryFunction<InputT, KeyT> keyExtractor, @Nullable TypeDescriptor<KeyT> keyType, UnaryFunction<InputT, ValueT> valueExtractor, @Nullable TypeDescriptor<ValueT> valueType, ReduceFunctor<ValueT, OutputT> reducer, @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator, @Nullable Window<InputT> window, @Nullable TypeDescriptor<KV<KeyT, OutputT>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
        this.reducer = Objects.requireNonNull(reducer);
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
        this.valueType = valueType;
        this.valueComparator = valueComparator;
        this.accumulatorFactory = null;
        this.accumulate = null;
        this.mergeAccumulators = null;
        this.outputFn = null;
        this.accumulatorType = null;
    }

    private ReduceByKey(@Nullable String name, UnaryFunction<InputT, KeyT> keyExtractor, @Nullable TypeDescriptor<KeyT> keyType, UnaryFunction<InputT, ValueT> valueExtractor, @Nullable TypeDescriptor<ValueT> valueType, VoidFunction<AccT> accumulatorFactory, BinaryFunction<AccT, ValueT, AccT> accumulate, CombinableBinaryFunction<AccT> mergeAccumulators, UnaryFunction<AccT, OutputT> outputFn, TypeDescriptor<AccT> accumulatorType, @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator, @Nullable Window<InputT> window, @Nullable TypeDescriptor<KV<KeyT, OutputT>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
        this.reducer = null;
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
        this.valueType = valueType;
        this.valueComparator = valueComparator;
        this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory);
        this.accumulate = Objects.requireNonNull(accumulate);
        this.mergeAccumulators = Objects.requireNonNull(mergeAccumulators);
        this.outputFn = Objects.requireNonNull(outputFn);
        this.accumulatorType = accumulatorType;
    }

    public boolean isCombineFnStyle() {
        return this.reducer == null;
    }

    public ReduceFunctor<ValueT, OutputT> getReducer() {
        return Objects.requireNonNull(this.reducer, "Don't call #getReducer when #isCombinableFnStyle() == true");
    }

    public VoidFunction<AccT> getAccumulatorFactory() {
        return Objects.requireNonNull(this.accumulatorFactory, "Don't vall #getAccumulatorFactory when #isCombinableFnStyle() == false");
    }

    public BinaryFunction<AccT, ValueT, AccT> getAccumulate() {
        return Objects.requireNonNull(this.accumulate, "Don't vall #getAccumulate when #isCombinableFnStyle() == false");
    }

    public CombinableBinaryFunction<AccT> getMergeAccumulators() {
        return Objects.requireNonNull(this.mergeAccumulators, "Don't vall #getMergeAccumulators when #isCombinableFnStyle() == false");
    }

    public UnaryFunction<AccT, OutputT> getOutputFn() {
        return Objects.requireNonNull(this.outputFn, "Don't vall #getOutputFn when #isCombinableFnStyle() == false");
    }

    public TypeDescriptor<AccT> getAccumulatorType() {
        return this.accumulatorType;
    }

    public boolean isCombinable() {
        return this.isCombineFnStyle() || this.reducer.isCombinable();
    }

    public UnaryFunction<InputT, ValueT> getValueExtractor() {
        return this.valueExtractor;
    }

    public Optional<BinaryFunction<ValueT, ValueT, Integer>> getValueComparator() {
        return Optional.ofNullable(this.valueComparator);
    }

    @Override
    public Optional<TypeDescriptor<ValueT>> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    static class Builder<InputT, KeyT, ValueT, AccT, OutputT>
    implements OfBuilder,
    KeyByBuilder<InputT>,
    ValueByReduceByBuilder<InputT, KeyT, ValueT>,
    WithSortedValuesBuilder<KeyT, ValueT, OutputT>,
    WindowByInternalBuilder<InputT, KeyT, OutputT>,
    WindowByBuilder<KeyT, OutputT>,
    TriggeredByBuilder<KeyT, OutputT>,
    AccumulationModeBuilder<KeyT, OutputT>,
    WindowedOutputBuilder<KeyT, OutputT>,
    OutputBuilder<KeyT, OutputT> {
        private final WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        private final @Nullable String name;
        private PCollection<InputT> input;
        private UnaryFunction<InputT, KeyT> keyExtractor;
        private @Nullable TypeDescriptor<KeyT> keyType;
        private @Nullable UnaryFunction<InputT, ValueT> valueExtractor;
        private @Nullable TypeDescriptor<ValueT> valueType;
        private @Nullable TypeDescriptor<OutputT> outputType;
        private @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator;
        private final @Nullable ReduceFunctor<ValueT, OutputT> reducer;
        private final @Nullable VoidFunction<AccT> accumulatorFactory;
        private final @Nullable BinaryFunction<AccT, ValueT, AccT> accumulate;
        private final @Nullable CombinableBinaryFunction<AccT> mergeAccumulators;
        private final @Nullable UnaryFunction<AccT, OutputT> outputFn;
        private final @Nullable TypeDescriptor<AccT> accumulatorTypeDescriptor;

        Builder(@Nullable String name) {
            this.name = name;
            this.reducer = null;
            this.accumulatorFactory = null;
            this.accumulate = null;
            this.mergeAccumulators = null;
            this.outputFn = null;
            this.accumulatorTypeDescriptor = null;
        }

        private Builder(Builder parent, VoidFunction<AccT> accumulatorFactory, BinaryFunction<AccT, ValueT, AccT> accumulate, CombinableBinaryFunction<AccT> mergeAccumulators, UnaryFunction<AccT, OutputT> outputFn, @Nullable TypeDescriptor<AccT> accumulatorTypeDescriptor) {
            this.name = parent.name;
            this.input = parent.input;
            this.keyExtractor = parent.keyExtractor;
            this.keyType = parent.keyType;
            this.valueExtractor = parent.valueExtractor;
            this.valueType = parent.valueType;
            this.outputType = parent.outputType;
            this.valueComparator = parent.valueComparator;
            this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory);
            this.accumulate = Objects.requireNonNull(accumulate);
            this.mergeAccumulators = Objects.requireNonNull(mergeAccumulators);
            this.outputFn = Objects.requireNonNull(outputFn);
            this.accumulatorTypeDescriptor = accumulatorTypeDescriptor;
            this.reducer = null;
        }

        private Builder(Builder parent, ReduceFunctor<ValueT, OutputT> reducer) {
            this.name = parent.name;
            this.input = parent.input;
            this.keyExtractor = parent.keyExtractor;
            this.keyType = parent.keyType;
            this.valueExtractor = parent.valueExtractor;
            this.valueType = parent.valueType;
            this.outputType = parent.outputType;
            this.valueComparator = parent.valueComparator;
            this.accumulatorFactory = null;
            this.accumulate = null;
            this.mergeAccumulators = null;
            this.outputFn = null;
            this.accumulatorTypeDescriptor = null;
            this.reducer = Objects.requireNonNull(reducer);
        }

        public <T> KeyByBuilder<T> of(PCollection<T> input) {
            Builder cast = this;
            cast.input = input;
            return cast;
        }

        @Override
        public <T> ValueByReduceByBuilder<InputT, T, InputT> keyBy(UnaryFunction<InputT, T> keyExtractor, @Nullable TypeDescriptor<T> keyType) {
            Builder cast = this;
            cast.keyExtractor = Objects.requireNonNull(keyExtractor);
            cast.keyType = keyType;
            return cast;
        }

        @Override
        public <T> ReduceByBuilder<KeyT, T> valueBy(UnaryFunction<InputT, T> valueExtractor, @Nullable TypeDescriptor<T> valueType) {
            Builder cast = this;
            cast.valueExtractor = Objects.requireNonNull(valueExtractor);
            cast.valueType = valueType;
            return cast;
        }

        @Override
        public <T> WithSortedValuesBuilder<KeyT, ValueT, T> reduceBy(ReduceFunctor<ValueT, T> reducer, @Nullable TypeDescriptor<T> outputType) {
            Builder<InputT, KeyT, ValueT, AccT, T> cast = new Builder<InputT, KeyT, ValueT, AccT, T>(this, reducer);
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public <NewAccT, T> WindowByBuilder<KeyT, T> combineBy(VoidFunction<NewAccT> accumulatorFactory, BinaryFunction<NewAccT, ValueT, NewAccT> accumulate, CombinableBinaryFunction<NewAccT> mergeAccumulators, UnaryFunction<NewAccT, T> outputFn, TypeDescriptor<NewAccT> accumulatorDescriptor, TypeDescriptor<T> outputDescriptor) {
            Builder<InputT, KeyT, ValueT, NewAccT, T> ret = new Builder<InputT, KeyT, ValueT, NewAccT, T>(this, accumulatorFactory, accumulate, mergeAccumulators, outputFn, accumulatorDescriptor);
            ret.valueType = this.valueType;
            ret.outputType = outputDescriptor;
            return ret;
        }

        @Override
        public WindowByBuilder<KeyT, OutputT> withSortedValues(BinaryFunction<ValueT, ValueT, Integer> valueComparator) {
            this.valueComparator = Objects.requireNonNull(valueComparator);
            return this;
        }

        @Override
        public OutputBuilder<KeyT, OutputT> windowBy(Window<InputT> window) {
            this.windowBuilder.setWindow(window);
            return this;
        }

        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT, OutputT> windowBy(WindowFn<Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public AccumulationModeBuilder<KeyT, OutputT> triggeredBy(Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withTimestampCombiner(TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public PCollection<KV<KeyT, OutputT>> output() {
            return OperatorTransform.apply(this.createOperator(), PCollectionList.of(this.input));
        }

        @Override
        public PCollection<OutputT> outputValues() {
            return OperatorTransform.apply(new OutputValues(this.name, this.outputType, this.createOperator()), PCollectionList.of(this.input));
        }

        private ReduceByKey<InputT, KeyT, ValueT, AccT, OutputT> createOperator() {
            if (this.valueExtractor == null) {
                this.valueExtractor = this.identity();
            }
            if (this.reducer != null) {
                return new ReduceByKey(this.name, this.keyExtractor, this.keyType, this.valueExtractor, this.valueType, this.reducer, this.valueComparator, this.windowBuilder.getWindow().orElse(null), TypeDescriptors.kvs(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeAwareness.orObjects(Optional.ofNullable(this.outputType))));
            }
            return new ReduceByKey(this.name, this.keyExtractor, this.keyType, this.valueExtractor, this.valueType, this.accumulatorFactory, this.accumulate, this.mergeAccumulators, this.outputFn, this.accumulatorTypeDescriptor, this.valueComparator, this.windowBuilder.getWindow().orElse(null), TypeDescriptors.kvs(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeAwareness.orObjects(Optional.ofNullable(this.outputType))));
        }

        private UnaryFunction<InputT, ValueT> identity() {
            return UnaryFunction.identity();
        }
    }

    public static interface OutputBuilder<KeyT, OutputT>
    extends Builders.Output<KV<KeyT, OutputT>>,
    Builders.OutputValues<KeyT, OutputT> {
    }

    public static interface WindowedOutputBuilder<KeyT, OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
    }

    public static interface AccumulationModeBuilder<KeyT, OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT, OutputT>> {
        @Override
        public WindowedOutputBuilder<KeyT, OutputT> accumulationMode(WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<KeyT, OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT, OutputT>> {
        @Override
        public AccumulationModeBuilder<KeyT, OutputT> triggeredBy(Trigger var1);
    }

    public static interface WindowByBuilder<KeyT, OutputT>
    extends Builders.WindowBy<TriggeredByBuilder<KeyT, OutputT>>,
    OptionalMethodBuilder<WindowByBuilder<KeyT, OutputT>, OutputBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT, OutputT> windowBy(WindowFn<Object, W> var1);

        @Override
        default public OutputBuilder<KeyT, OutputT> applyIf(boolean cond, UnaryFunction<WindowByBuilder<KeyT, OutputT>, OutputBuilder<KeyT, OutputT>> fn) {
            Objects.requireNonNull(fn);
            return cond ? fn.apply(this) : this;
        }
    }

    @Internal
    public static interface WindowByInternalBuilder<InputT, KeyT, OutputT> {
        public OutputBuilder<KeyT, OutputT> windowBy(Window<InputT> var1);
    }

    public static interface WithSortedValuesBuilder<KeyT, ValueT, OutputT>
    extends WindowByBuilder<KeyT, OutputT> {
        public WindowByBuilder<KeyT, OutputT> withSortedValues(BinaryFunction<ValueT, ValueT, Integer> var1);
    }

    public static interface ValueByReduceByBuilder<InputT, KeyT, ValueT>
    extends ReduceByBuilder<KeyT, ValueT> {
        public <T> ReduceByBuilder<KeyT, T> valueBy(UnaryFunction<InputT, T> var1, @Nullable TypeDescriptor<T> var2);

        default public <T> ReduceByBuilder<KeyT, T> valueBy(UnaryFunction<InputT, T> valueExtractor) {
            return this.valueBy(valueExtractor, null);
        }
    }

    public static interface ReduceByBuilder<KeyT, ValueT> {
        default public <OutputT> WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(ReduceFunction<ValueT, OutputT> reducer) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)));
        }

        default public <OutputT> WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(ReduceFunction<ValueT, OutputT> reducer, TypeDescriptor<OutputT> outputType) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)), outputType);
        }

        default public <OutputT> WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(ReduceFunctor<ValueT, OutputT> reducer) {
            return this.reduceBy(reducer, null);
        }

        public <OutputT> WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(ReduceFunctor<ValueT, OutputT> var1, @Nullable TypeDescriptor<OutputT> var2);

        default public WindowByBuilder<KeyT, ValueT> combineBy(CombinableReduceFunction<ValueT> reducer) {
            return this.reduceBy(ReduceFunctor.of(reducer));
        }

        default public WindowByBuilder<KeyT, ValueT> combineBy(CombinableReduceFunction<ValueT> reducer, TypeDescriptor<ValueT> outputType) {
            return this.reduceBy(ReduceFunctor.of(reducer), outputType);
        }

        default public WindowByBuilder<KeyT, ValueT> combineBy(CombineFunctionWithIdentity<ValueT> reduce) {
            return this.combineBy(reduce.identity(), reduce, reduce.valueDesc());
        }

        @Deprecated
        default public WindowByBuilder<KeyT, ValueT> combineBy(CombineFunctionWithIdentity<ValueT> reduce, TypeDescriptor<ValueT> ignored) {
            return this.combineBy(reduce);
        }

        default public WindowByBuilder<KeyT, ValueT> combineBy(ValueT identity, CombinableBinaryFunction<ValueT> reducer) {
            return this.combineBy(identity, reducer, null);
        }

        default public WindowByBuilder<KeyT, ValueT> combineBy(ValueT identity, CombinableBinaryFunction<ValueT> reducer, @Nullable TypeDescriptor<ValueT> valueType) {
            return this.combineBy(() -> identity, reducer, reducer, e -> e, valueType, valueType);
        }

        default public <AccT> WindowByBuilder<KeyT, ValueT> combineBy(VoidFunction<AccT> accumulatorFactory, BinaryFunction<AccT, ValueT, AccT> accumulate, CombinableBinaryFunction<AccT> mergeAccumulators, UnaryFunction<AccT, ValueT> outputFn) {
            return this.combineBy(accumulatorFactory, accumulate, mergeAccumulators, outputFn, null, null);
        }

        public <AccT, OutputT> WindowByBuilder<KeyT, OutputT> combineBy(VoidFunction<AccT> var1, BinaryFunction<AccT, ValueT, AccT> var2, CombinableBinaryFunction<AccT> var3, UnaryFunction<AccT, OutputT> var4, @Nullable TypeDescriptor<AccT> var5, @Nullable TypeDescriptor<OutputT> var6);
    }

    public static interface KeyByBuilder<InputT>
    extends Builders.KeyBy<InputT> {
        public <T> ValueByReduceByBuilder<InputT, T, InputT> keyBy(UnaryFunction<InputT, T> var1, TypeDescriptor<T> var2);

        default public <T> ValueByReduceByBuilder<InputT, T, InputT> keyBy(UnaryFunction<InputT, T> keyExtractor) {
            return this.keyBy((UnaryFunction)keyExtractor, (TypeDescriptor)null);
        }
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> KeyByBuilder<InputT> of(PCollection<InputT> var1);
    }

    public static interface CombineFunctionWithIdentity<T>
    extends CombinableBinaryFunction<T> {
        public T identity();

        default public TypeDescriptor<T> valueDesc() {
            return null;
        }
    }
}

