/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Recommended;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.OutputValues;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Recommended(reason="Might be useful to override because of performance reasons in a specific join types (e.g. sort join), which might reduce the space complexity", state=StateComplexity.LINEAR, repartitions=1)
public class Join<LeftT, RightT, KeyT, OutputT>
extends ShuffleOperator<Object, KeyT, KV<KeyT, OutputT>> {
    private final Type type;
    private final UnaryFunction<LeftT, KeyT> leftKeyExtractor;
    private final UnaryFunction<RightT, KeyT> rightKeyExtractor;
    private final BinaryFunctor<LeftT, RightT, OutputT> functor;

    public static <LeftT, RightT> ByBuilder<LeftT, RightT> of(PCollection<LeftT> left, PCollection<RightT> right) {
        return Join.named(null).of(left, right);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name, Type.INNER);
    }

    private Join(@Nullable String name, Type type, UnaryFunction<LeftT, KeyT> leftKeyExtractor, UnaryFunction<RightT, KeyT> rightKeyExtractor, @Nullable TypeDescriptor<KeyT> keyType, BinaryFunctor<LeftT, RightT, OutputT> functor, @Nullable TypeDescriptor<KV<KeyT, OutputT>> outputType, @Nullable Window<Object> window) {
        super(name, outputType, null, keyType, window);
        this.type = type;
        this.leftKeyExtractor = leftKeyExtractor;
        this.rightKeyExtractor = rightKeyExtractor;
        this.functor = functor;
    }

    public Type getType() {
        return this.type;
    }

    public UnaryFunction<LeftT, KeyT> getLeftKeyExtractor() {
        return this.leftKeyExtractor;
    }

    public UnaryFunction<RightT, KeyT> getRightKeyExtractor() {
        return this.rightKeyExtractor;
    }

    public BinaryFunctor<LeftT, RightT, OutputT> getJoiner() {
        return this.functor;
    }

    static class Builder<LeftT, RightT, KeyT, OutputT>
    implements OfBuilder,
    ByBuilder<LeftT, RightT>,
    UsingBuilder<LeftT, RightT, KeyT>,
    WindowByBuilder<KeyT, OutputT>,
    TriggeredByBuilder<KeyT, OutputT>,
    AccumulationModeBuilder<KeyT, OutputT>,
    WindowedOutputBuilder<KeyT, OutputT>,
    OutputBuilder<KeyT, OutputT> {
        private final WindowBuilder<Object> windowBuilder = new WindowBuilder();
        private final @Nullable String name;
        private final Type type;
        private PCollection<LeftT> left;
        private PCollection<RightT> right;
        private UnaryFunction<LeftT, KeyT> leftKeyExtractor;
        private UnaryFunction<RightT, KeyT> rightKeyExtractor;
        private @Nullable TypeDescriptor<KeyT> keyType;
        private BinaryFunctor<LeftT, RightT, OutputT> joinFunc;
        private @Nullable TypeDescriptor<OutputT> outputType;

        Builder(@Nullable String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public <FirstT, SecondT> ByBuilder<FirstT, SecondT> of(PCollection<FirstT> left, PCollection<SecondT> right) {
            Builder cast = this;
            cast.left = Objects.requireNonNull(left);
            cast.right = Objects.requireNonNull(right);
            return cast;
        }

        @Override
        public <T> UsingBuilder<LeftT, RightT, T> by(UnaryFunction<LeftT, T> leftKeyExtractor, UnaryFunction<RightT, T> rightKeyExtractor, @Nullable TypeDescriptor<T> keyType) {
            Builder cast = this;
            cast.leftKeyExtractor = leftKeyExtractor;
            cast.rightKeyExtractor = rightKeyExtractor;
            cast.keyType = keyType;
            return cast;
        }

        @Override
        public <T> WindowByBuilder<KeyT, T> using(BinaryFunctor<LeftT, RightT, T> joinFunc, @Nullable TypeDescriptor<T> outputType) {
            Builder cast = this;
            cast.joinFunc = Objects.requireNonNull(joinFunc);
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT, OutputT> windowBy(WindowFn<Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public AccumulationModeBuilder<KeyT, OutputT> triggeredBy(Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withTimestampCombiner(TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public PCollection<KV<KeyT, OutputT>> output() {
            PCollectionList inputs = PCollectionList.of(Arrays.asList(this.left, this.right));
            return OperatorTransform.apply(this.createOperator(), inputs);
        }

        @Override
        public PCollection<OutputT> outputValues() {
            PCollectionList inputs = PCollectionList.of(Arrays.asList(this.left, this.right));
            return OperatorTransform.apply(new OutputValues(this.name, this.outputType, this.createOperator()), inputs);
        }

        private Join<LeftT, RightT, KeyT, OutputT> createOperator() {
            return new Join(this.name, this.type, this.leftKeyExtractor, this.rightKeyExtractor, this.keyType, this.joinFunc, TypeDescriptors.kvs(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeAwareness.orObjects(Optional.ofNullable(this.outputType))), this.windowBuilder.getWindow().orElse(null));
        }
    }

    public static interface OutputBuilder<KeyT, OutputT>
    extends Builders.Output<KV<KeyT, OutputT>>,
    Builders.OutputValues<KeyT, OutputT> {
    }

    public static interface WindowedOutputBuilder<KeyT, OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
    }

    public static interface AccumulationModeBuilder<KeyT, OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT, OutputT>> {
    }

    public static interface TriggeredByBuilder<KeyT, OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT, OutputT>> {
    }

    public static interface WindowByBuilder<KeyT, OutputT>
    extends OptionalMethodBuilder<WindowByBuilder<KeyT, OutputT>, OutputBuilder<KeyT, OutputT>>,
    Builders.WindowBy<TriggeredByBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
        @Override
        default public OutputBuilder<KeyT, OutputT> applyIf(boolean cond, UnaryFunction<WindowByBuilder<KeyT, OutputT>, OutputBuilder<KeyT, OutputT>> fn) {
            return cond ? Objects.requireNonNull(fn).apply(this) : this;
        }
    }

    public static interface UsingBuilder<LeftT, RightT, KeyT> {
        public <OutputT> WindowByBuilder<KeyT, OutputT> using(BinaryFunctor<LeftT, RightT, OutputT> var1, @Nullable TypeDescriptor<OutputT> var2);

        default public <OutputT> WindowByBuilder<KeyT, OutputT> using(BinaryFunctor<LeftT, RightT, OutputT> joinFunc) {
            return this.using(joinFunc, null);
        }
    }

    public static interface ByBuilder<LeftT, RightT> {
        public <K> UsingBuilder<LeftT, RightT, K> by(UnaryFunction<LeftT, K> var1, UnaryFunction<RightT, K> var2, @Nullable TypeDescriptor<K> var3);

        default public <T> UsingBuilder<LeftT, RightT, T> by(UnaryFunction<LeftT, T> leftKeyExtractor, UnaryFunction<RightT, T> rightKeyExtractor) {
            return this.by(leftKeyExtractor, rightKeyExtractor, null);
        }
    }

    public static interface OfBuilder {
        public <LeftT, RightT> ByBuilder<LeftT, RightT> of(PCollection<LeftT> var1, PCollection<RightT> var2);
    }

    public static enum Type {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

