/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Basic;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ExtractEventTime;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Basic(state=StateComplexity.ZERO, repartitions=0)
public class FlatMap<InputT, OutputT>
extends Operator<OutputT>
implements TypeAware.Output<OutputT> {
    private final UnaryFunctor<InputT, OutputT> functor;
    private final @Nullable ExtractEventTime<InputT> eventTimeFn;
    private final Duration allowedTimestampSkew;

    public static <InputT> UsingBuilder<InputT> of(PCollection<InputT> input) {
        return FlatMap.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private FlatMap(@Nullable String name, UnaryFunctor<InputT, OutputT> functor, @Nullable TypeDescriptor<OutputT> outputType, @Nullable ExtractEventTime<InputT> evtTimeFn, Duration allowedTimestampSkew) {
        super(name, outputType);
        this.functor = functor;
        this.eventTimeFn = evtTimeFn;
        this.allowedTimestampSkew = Objects.requireNonNull(allowedTimestampSkew);
    }

    public UnaryFunctor<InputT, OutputT> getFunctor() {
        return this.functor;
    }

    public Optional<ExtractEventTime<InputT>> getEventTimeExtractor() {
        return Optional.ofNullable(this.eventTimeFn);
    }

    public Duration getAllowedTimestampSkew() {
        return this.allowedTimestampSkew;
    }

    public static class Builder<InputT, OutputT>
    implements OfBuilder,
    UsingBuilder<InputT>,
    EventTimeBuilder<InputT, OutputT>,
    Builders.Output<OutputT> {
        private final @Nullable String name;
        private PCollection<InputT> input;
        private UnaryFunctor<InputT, OutputT> functor;
        private @Nullable TypeDescriptor<OutputT> outputType;
        private @Nullable ExtractEventTime<InputT> evtTimeFn;
        private Duration allowedTimestampSkew = Duration.millis((long)Long.MAX_VALUE);

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <InputLocalT> UsingBuilder<InputLocalT> of(PCollection<InputLocalT> input) {
            Builder cast = this;
            cast.input = Objects.requireNonNull(input);
            return cast;
        }

        @Override
        public <OutputLocalT> EventTimeBuilder<InputT, OutputLocalT> using(UnaryFunctor<InputT, OutputLocalT> functor) {
            return this.using(functor, (TypeDescriptor<OutputLocalT>)null);
        }

        @Override
        public <OutputLocalT> EventTimeBuilder<InputT, OutputLocalT> using(UnaryFunctor<InputT, OutputLocalT> functor, TypeDescriptor<OutputLocalT> outputType) {
            Builder cast = this;
            cast.functor = Objects.requireNonNull(functor);
            cast.outputType = outputType;
            return cast;
        }

        @Override
        public Builders.Output<OutputT> eventTimeBy(ExtractEventTime<InputT> eventTimeFn, @Nullable Duration timestampSkew) {
            this.evtTimeFn = Objects.requireNonNull(eventTimeFn);
            this.allowedTimestampSkew = (Duration)MoreObjects.firstNonNull((Object)timestampSkew, (Object)Duration.millis((long)Long.MAX_VALUE));
            return this;
        }

        @Override
        public PCollection<OutputT> output() {
            return OperatorTransform.apply(new FlatMap(this.name, this.functor, this.outputType, this.evtTimeFn, this.allowedTimestampSkew), PCollectionList.of(this.input));
        }
    }

    public static interface EventTimeBuilder<InputT, OutputT>
    extends Builders.Output<OutputT> {
        default public Builders.Output<OutputT> eventTimeBy(ExtractEventTime<InputT> eventTimeFn) {
            return this.eventTimeBy(eventTimeFn, null);
        }

        public Builders.Output<OutputT> eventTimeBy(ExtractEventTime<InputT> var1, @Nullable Duration var2);
    }

    public static interface UsingBuilder<InputT> {
        public <OutputT> EventTimeBuilder<InputT, OutputT> using(UnaryFunctor<InputT, OutputT> var1);

        public <OutputT> EventTimeBuilder<InputT, OutputT> using(UnaryFunctor<InputT, OutputT> var1, TypeDescriptor<OutputT> var2);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> UsingBuilder<InputT> of(PCollection<InputT> var1);
    }
}

