/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ExtractEventTime;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class AssignEventTime<InputT>
extends Operator<InputT>
implements CompositeOperator<InputT, InputT> {
    private final ExtractEventTime<InputT> eventTimeExtractor;
    private final @Nullable Duration allowedTimestampSkew;

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    public static <InputT> UsingBuilder<InputT> of(PCollection<InputT> input) {
        return AssignEventTime.named(null).of((PCollection)input);
    }

    private AssignEventTime(@Nullable String name, ExtractEventTime<InputT> eventTimeExtractor, @Nullable Duration allowedTimestampSkew, @Nullable TypeDescriptor<InputT> outputType) {
        super(name, outputType);
        this.eventTimeExtractor = eventTimeExtractor;
        this.allowedTimestampSkew = allowedTimestampSkew;
    }

    public ExtractEventTime<InputT> getEventTimeExtractor() {
        return this.eventTimeExtractor;
    }

    @Override
    public PCollection<InputT> expand(PCollectionList<InputT> inputs) {
        PCollection<InputT> input = PCollectionLists.getOnlyElement(inputs);
        return FlatMap.named(this.getName().orElse(null)).of((PCollection)input).using((element, coll) -> coll.collect(element), input.getTypeDescriptor()).eventTimeBy(this.getEventTimeExtractor(), this.allowedTimestampSkew).output();
    }

    public static class Builder<InputT>
    implements OfBuilder,
    UsingBuilder<InputT>,
    Builders.Output<InputT> {
        private final @Nullable String name;
        private PCollection<InputT> input;
        private ExtractEventTime<InputT> eventTimeExtractor;
        private @Nullable Duration allowedTimestampSkew = null;

        private Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> UsingBuilder<T> of(PCollection<T> input) {
            Builder cast = this;
            cast.input = input;
            return cast;
        }

        @Override
        public Builders.Output<InputT> using(ExtractEventTime<InputT> eventTimeExtractor) {
            this.eventTimeExtractor = eventTimeExtractor;
            return this;
        }

        @Override
        public Builders.Output<InputT> using(ExtractEventTime<InputT> eventTimeExtractor, Duration allowedTimestampSkew) {
            this.allowedTimestampSkew = allowedTimestampSkew;
            return this.using(eventTimeExtractor);
        }

        @Override
        public PCollection<InputT> output() {
            return OperatorTransform.apply(new AssignEventTime(this.name, this.eventTimeExtractor, this.allowedTimestampSkew, this.input.getTypeDescriptor()), PCollectionList.of(this.input));
        }
    }

    public static interface UsingBuilder<InputT> {
        public Builders.Output<InputT> using(ExtractEventTime<InputT> var1);

        public Builders.Output<InputT> using(ExtractEventTime<InputT> var1, Duration var2);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> UsingBuilder<InputT> of(PCollection<InputT> var1);
    }
}

