/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.accumulators;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Counter;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Histogram;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoidAccumulatorProvider
implements AccumulatorProvider {
    private static final Logger LOG = LoggerFactory.getLogger(VoidAccumulatorProvider.class);

    private VoidAccumulatorProvider() {
    }

    public static Factory getFactory() {
        return Factory.get();
    }

    @Override
    public Counter getCounter(String name) {
        return VoidCounter.INSTANCE;
    }

    @Override
    public Counter getCounter(String namespace, String name) {
        return VoidCounter.INSTANCE;
    }

    @Override
    public Histogram getHistogram(String name) {
        return VoidHistogram.INSTANCE;
    }

    @Override
    public Histogram getHistogram(String namespace, String name) {
        return VoidHistogram.INSTANCE;
    }

    @Override
    public Timer getTimer(String name) {
        return VoidTimer.INSTANCE;
    }

    public static class VoidTimer
    implements Timer {
        private static final VoidTimer INSTANCE = new VoidTimer();

        private VoidTimer() {
        }

        @Override
        public void add(Duration duration) {
        }
    }

    public static class VoidHistogram
    implements Histogram {
        private static final VoidHistogram INSTANCE = new VoidHistogram();

        private VoidHistogram() {
        }

        @Override
        public void add(long value) {
        }

        @Override
        public void add(long value, long times) {
        }
    }

    private static class VoidCounter
    implements Counter {
        private static final VoidCounter INSTANCE = new VoidCounter();

        private VoidCounter() {
        }

        @Override
        public void increment(long value) {
        }

        @Override
        public void increment() {
        }
    }

    public static class Factory
    implements AccumulatorProvider.Factory {
        private static final Factory INSTANCE = new Factory();
        private static final AccumulatorProvider PROVIDER = new VoidAccumulatorProvider();
        private static final AtomicBoolean isLogged = new AtomicBoolean();

        private Factory() {
        }

        public static Factory get() {
            return INSTANCE;
        }

        @Override
        public AccumulatorProvider create() {
            if (isLogged.compareAndSet(false, true)) {
                LOG.warn("Using accumulators with VoidAccumulatorProvider will have no effect");
            }
            return PROVIDER;
        }
    }
}

