/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.stability.Experimental;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Join;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Union;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.CompositeOperatorTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.FlatMapTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.JoinTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.ReduceByKeyTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.TranslatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.translate.UnionTranslator;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

@Experimental
public class GenericTranslatorProvider
implements TranslatorProvider {
    private final List<TranslationDescriptor> possibleTranslators;

    public static GenericTranslatorProvider createWithDefaultTranslators() {
        return GenericTranslatorProvider.newBuilder().register(FlatMap.class, new FlatMapTranslator()).register(Union.class, new UnionTranslator()).register(ReduceByKey.class, new ReduceByKeyTranslator()).register(Join.class, new JoinTranslator()).register(op -> op instanceof CompositeOperator, new CompositeOperatorTranslator()).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private GenericTranslatorProvider(List<TranslationDescriptor> possibleTranslators) {
        this.possibleTranslators = possibleTranslators;
    }

    @Override
    public <InputT, OutputT, OperatorT extends Operator<OutputT>> Optional<OperatorTranslator<InputT, OutputT, OperatorT>> findTranslator(OperatorT operator) {
        for (TranslationDescriptor descriptor : this.possibleTranslators) {
            Optional<OperatorTranslator<InputT, OutputT, OperatorT>> maybeTranslator = descriptor.getTranslatorWhenSuitable(operator);
            if (!maybeTranslator.isPresent()) continue;
            return maybeTranslator;
        }
        return Optional.empty();
    }

    private static class TranslationDescriptor<OperatorT extends Operator<?>> {
        private final Optional<Class<OperatorT>> operatorClass;
        private final Optional<Predicate<OperatorT>> userDefinedPredicate;
        private final OperatorTranslator<?, ?, OperatorT> translator;

        private TranslationDescriptor(Optional<Class<OperatorT>> operatorClass, Optional<Predicate<OperatorT>> userDefinedPredicate, OperatorTranslator<?, ?, ? extends OperatorT> translator) {
            Preconditions.checkState((operatorClass.isPresent() || userDefinedPredicate.isPresent() ? 1 : 0) != 0, (Object)"At least user defined predicate or class of an operator have to be given.");
            OperatorTranslator<?, ?, ? extends OperatorT> castedTranslator = translator;
            this.operatorClass = operatorClass;
            this.userDefinedPredicate = userDefinedPredicate;
            this.translator = castedTranslator;
        }

        static <OperatorT extends Operator<?>> TranslationDescriptor<OperatorT> of(Class<OperatorT> operatorClass, Predicate<OperatorT> userDefinedPredicate, OperatorTranslator<?, ?, ? extends OperatorT> translator) {
            return new TranslationDescriptor<OperatorT>(Optional.of(Objects.requireNonNull(operatorClass)), Optional.of(Objects.requireNonNull(userDefinedPredicate)), Objects.requireNonNull(translator));
        }

        static <OperatorT extends Operator<?>> TranslationDescriptor<OperatorT> of(Predicate<OperatorT> userDefinedPredicate, OperatorTranslator<?, ?, ? extends OperatorT> translator) {
            return new TranslationDescriptor<OperatorT>(Optional.empty(), Optional.of(userDefinedPredicate), Objects.requireNonNull(translator));
        }

        static <OperatorT extends Operator<?>> TranslationDescriptor<OperatorT> of(Class<OperatorT> operatorClass, OperatorTranslator<?, ?, ? extends OperatorT> translator) {
            return new TranslationDescriptor<OperatorT>(Optional.of(Objects.requireNonNull(operatorClass)), Optional.empty(), Objects.requireNonNull(translator));
        }

        private boolean checkTranslatorSuitableFor(OperatorT operator) {
            if (this.operatorClass.isPresent() && !this.operatorClass.get().equals(operator.getClass())) {
                return false;
            }
            if (this.userDefinedPredicate.isPresent() && !this.userDefinedPredicate.get().test(operator)) {
                return false;
            }
            return this.translator.canTranslate(operator);
        }

        Optional<OperatorTranslator<?, ?, OperatorT>> getTranslatorWhenSuitable(OperatorT operator) {
            if (this.checkTranslatorSuitableFor(operator)) {
                return Optional.of(this.translator);
            }
            return Optional.empty();
        }
    }

    public static class Builder {
        private final List<TranslationDescriptor> possibleTranslators = new ArrayList<TranslationDescriptor>();

        private Builder() {
        }

        public <OperatorT extends Operator<?>> Builder register(Class<OperatorT> clazz, OperatorTranslator<?, ?, ? extends OperatorT> operatorTranslator) {
            this.possibleTranslators.add(TranslationDescriptor.of(clazz, operatorTranslator));
            return this;
        }

        public <OperatorT extends Operator<?>> Builder register(Class<OperatorT> clazz, Predicate<OperatorT> predicate, OperatorTranslator<?, ?, ? extends OperatorT> operatorTranslator) {
            this.possibleTranslators.add(TranslationDescriptor.of(clazz, predicate, operatorTranslator));
            return this;
        }

        public Builder register(Predicate<Operator> predicate, OperatorTranslator<?, ?, Operator> operatorTranslator) {
            this.possibleTranslators.add(TranslationDescriptor.of(predicate, operatorTranslator));
            return this;
        }

        public GenericTranslatorProvider build() {
            return new GenericTranslatorProvider(this.possibleTranslators);
        }
    }
}

