/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Counter;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Histogram;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Timer;

class LazyAccumulatorProvider
implements AccumulatorProvider,
Serializable {
    private final AccumulatorProvider.Factory factory;
    private transient AccumulatorProvider accumulators;

    LazyAccumulatorProvider(AccumulatorProvider.Factory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    @Override
    public Counter getCounter(String name) {
        return this.getAccumulatorProvider().getCounter(name);
    }

    @Override
    public Counter getCounter(String namespace, String name) {
        return this.getAccumulatorProvider().getCounter(namespace, name);
    }

    @Override
    public Histogram getHistogram(String name) {
        return this.getAccumulatorProvider().getHistogram(name);
    }

    @Override
    public Histogram getHistogram(String namespace, String name) {
        return this.getAccumulatorProvider().getHistogram(namespace, name);
    }

    @Override
    public Timer getTimer(String name) {
        return this.getAccumulatorProvider().getTimer(name);
    }

    private AccumulatorProvider getAccumulatorProvider() {
        if (this.accumulators == null) {
            this.accumulators = this.factory.create();
        }
        return this.accumulators;
    }
}

