/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Join;
import org.apache.beam.sdk.extensions.euphoria.core.translate.AbstractJoinTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.LazyAccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.AdaptableCollector;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;

public class JoinTranslator<LeftT, RightT, KeyT, OutputT>
extends AbstractJoinTranslator<LeftT, RightT, KeyT, OutputT> {
    private static <KeyT, LeftT, RightT, OutputT> JoinFn<LeftT, RightT, KeyT, OutputT> getJoinFn(Join<LeftT, RightT, KeyT, OutputT> operator, TupleTag<LeftT> leftTag, TupleTag<RightT> rightTag, AccumulatorProvider accumulators) {
        BinaryFunctor<LeftT, RightT, OutputT> joiner = operator.getJoiner();
        switch (operator.getType()) {
            case INNER: {
                return new InnerJoinFn(joiner, leftTag, rightTag, operator.getName().orElse(null), accumulators);
            }
            case LEFT: {
                return new LeftOuterJoinFn(joiner, leftTag, rightTag, operator.getName().orElse(null), accumulators);
            }
            case RIGHT: {
                return new RightOuterJoinFn(joiner, leftTag, rightTag, operator.getName().orElse(null), accumulators);
            }
            case FULL: {
                return new FullJoinFn(joiner, leftTag, rightTag, operator.getName().orElse(null), accumulators);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot translate Euphoria '%s' operator to Beam transformations. Given join type '%s' is not supported.", new Object[]{Join.class.getSimpleName(), operator.getType()}));
    }

    @Override
    PCollection<KV<KeyT, OutputT>> translate(Join<LeftT, RightT, KeyT, OutputT> operator, PCollection<LeftT> left, PCollection<KV<KeyT, LeftT>> leftKeyed, PCollection<RightT> reight, PCollection<KV<KeyT, RightT>> rightKeyed) {
        LazyAccumulatorProvider accumulators = new LazyAccumulatorProvider(AccumulatorProvider.of(leftKeyed.getPipeline()));
        TupleTag leftTag = new TupleTag();
        TupleTag rightTag = new TupleTag();
        JoinFn<LeftT, RightT, KeyT, OutputT> joinFn = JoinTranslator.getJoinFn(operator, leftTag, rightTag, accumulators);
        return (PCollection)((PCollection)KeyedPCollectionTuple.of((TupleTag)leftTag, leftKeyed).and(rightTag, rightKeyed).apply("co-group-by-key", (PTransform)CoGroupByKey.create())).apply(joinFn.getFnName(), (PTransform)ParDo.of(joinFn));
    }

    private static class RightOuterJoinFn<LeftT, RightT, K, OutputT>
    extends JoinFn<LeftT, RightT, K, OutputT> {
        RightOuterJoinFn(BinaryFunctor<LeftT, RightT, OutputT> joiner, TupleTag<LeftT> leftTag, TupleTag<RightT> rightTag, @Nullable String operatorName, AccumulatorProvider accumulatorProvider) {
            super(joiner, leftTag, rightTag, operatorName, accumulatorProvider);
        }

        @Override
        void doJoin(Iterable<LeftT> left, Iterable<RightT> right) {
            for (RightT rightValue : right) {
                if (left.iterator().hasNext()) {
                    for (LeftT leftValue : left) {
                        this.getJoiner().apply(leftValue, rightValue, this.getCollector());
                    }
                    continue;
                }
                this.getJoiner().apply(null, rightValue, this.getCollector());
            }
        }

        @Override
        public String getFnName() {
            return "::right-outer-join";
        }
    }

    private static class LeftOuterJoinFn<LeftT, RightT, K, OutputT>
    extends JoinFn<LeftT, RightT, K, OutputT> {
        LeftOuterJoinFn(BinaryFunctor<LeftT, RightT, OutputT> joiner, TupleTag<LeftT> leftTag, TupleTag<RightT> rightTag, @Nullable String operatorName, AccumulatorProvider accumulatorProvider) {
            super(joiner, leftTag, rightTag, operatorName, accumulatorProvider);
        }

        @Override
        void doJoin(Iterable<LeftT> left, Iterable<RightT> right) {
            for (LeftT leftValue : left) {
                if (right.iterator().hasNext()) {
                    for (RightT rightValue : right) {
                        this.getJoiner().apply(leftValue, rightValue, this.getCollector());
                    }
                    continue;
                }
                this.getJoiner().apply(leftValue, null, this.getCollector());
            }
        }

        @Override
        public String getFnName() {
            return "left-outer-join";
        }
    }

    private static class FullJoinFn<LeftT, RightT, K, OutputT>
    extends JoinFn<LeftT, RightT, K, OutputT> {
        FullJoinFn(BinaryFunctor<LeftT, RightT, OutputT> joiner, TupleTag<LeftT> leftTag, TupleTag<RightT> rightTag, @Nullable String operatorName, AccumulatorProvider accumulatorProvider) {
            super(joiner, leftTag, rightTag, operatorName, accumulatorProvider);
        }

        @Override
        void doJoin(Iterable<LeftT> left, Iterable<RightT> right) {
            block5: {
                boolean rightHasValues;
                block6: {
                    boolean leftHasValues;
                    block4: {
                        leftHasValues = left.iterator().hasNext();
                        rightHasValues = right.iterator().hasNext();
                        if (!leftHasValues || !rightHasValues) break block4;
                        for (RightT rightValue : right) {
                            for (LeftT leftValue : left) {
                                this.getJoiner().apply(leftValue, rightValue, this.getCollector());
                            }
                        }
                        break block5;
                    }
                    if (!leftHasValues) break block6;
                    for (LeftT leftValue : left) {
                        this.getJoiner().apply(leftValue, null, this.getCollector());
                    }
                    break block5;
                }
                if (!rightHasValues) break block5;
                for (RightT rightValue : right) {
                    this.getJoiner().apply(null, rightValue, this.getCollector());
                }
            }
        }

        @Override
        public String getFnName() {
            return "full-join";
        }
    }

    private static class InnerJoinFn<LeftT, RightT, KeyT, OutputT>
    extends JoinFn<LeftT, RightT, KeyT, OutputT> {
        InnerJoinFn(BinaryFunctor<LeftT, RightT, OutputT> joiner, TupleTag<LeftT> leftTag, TupleTag<RightT> rightTag, @Nullable String operatorName, AccumulatorProvider accumulatorProvider) {
            super(joiner, leftTag, rightTag, operatorName, accumulatorProvider);
        }

        @Override
        protected void doJoin(Iterable<LeftT> left, Iterable<RightT> right) {
            for (LeftT leftItem : left) {
                for (RightT rightItem : right) {
                    this.getJoiner().apply(leftItem, rightItem, this.getCollector());
                }
            }
        }

        @Override
        String getFnName() {
            return "inner-join";
        }
    }

    private static abstract class JoinFn<LeftT, RightT, KeyT, OutputT>
    extends DoFn<KV<KeyT, CoGbkResult>, KV<KeyT, OutputT>> {
        private final BinaryFunctor<LeftT, RightT, OutputT> joiner;
        private final TupleTag<LeftT> leftTag;
        private final TupleTag<RightT> rightTag;
        private final AdaptableCollector<KV<KeyT, CoGbkResult>, KV<KeyT, OutputT>, OutputT> resultsCollector;

        JoinFn(BinaryFunctor<LeftT, RightT, OutputT> joiner, TupleTag<LeftT> leftTag, TupleTag<RightT> rightTag, @Nullable String operatorName, AccumulatorProvider accumulatorProvider) {
            this.joiner = joiner;
            this.leftTag = leftTag;
            this.rightTag = rightTag;
            this.resultsCollector = new AdaptableCollector(accumulatorProvider, operatorName, (ctx, elem) -> ctx.output((Object)KV.of((Object)((KV)ctx.element()).getKey(), (Object)elem)));
        }

        @DoFn.ProcessElement
        public final void processElement(@DoFn.Element KV<KeyT, CoGbkResult> element, DoFn.ProcessContext ctx) {
            this.getCollector().setProcessContext(ctx);
            this.doJoin(Objects.requireNonNull((CoGbkResult)element.getValue()).getAll(this.leftTag), Objects.requireNonNull((CoGbkResult)element.getValue()).getAll(this.rightTag));
        }

        abstract void doJoin(Iterable<LeftT> var1, Iterable<RightT> var2);

        abstract String getFnName();

        BinaryFunctor<LeftT, RightT, OutputT> getJoiner() {
            return this.joiner;
        }

        AdaptableCollector<KV<KeyT, CoGbkResult>, KV<KeyT, OutputT>, OutputT> getCollector() {
            return this.resultsCollector;
        }
    }
}

