/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.joda.time.Duration;

@Derived(state=StateComplexity.CONSTANT_IF_COMBINABLE, repartitions=1)
public class ReduceWindow<InputT, ValueT, OutputT>
extends ShuffleOperator<InputT, Byte, OutputT>
implements TypeAware.Value<ValueT>,
CompositeOperator<InputT, OutputT> {
    private static final Byte B_ZERO = 0;
    private final ReduceFunctor<ValueT, OutputT> reducer;
    private final UnaryFunction<InputT, ValueT> valueExtractor;
    @Nullable
    private final BinaryFunction<ValueT, ValueT, Integer> valueComparator;
    @Nullable
    private final TypeDescriptor<ValueT> valueType;

    public static <InputT> ValueByReduceByBuilder<InputT, InputT> of(PCollection<InputT> input) {
        return ReduceWindow.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private ReduceWindow(@Nullable String name, UnaryFunction<InputT, ValueT> valueExtractor, @Nullable TypeDescriptor<ValueT> valueType, ReduceFunctor<ValueT, OutputT> reducer, @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator, @Nullable Window<InputT> window, TypeDescriptor<OutputT> outputType) {
        super(name, outputType, e -> B_ZERO, TypeDescriptors.bytes(), window);
        this.reducer = reducer;
        this.valueExtractor = valueExtractor;
        this.valueType = valueType;
        this.valueComparator = valueComparator;
    }

    public ReduceFunctor<ValueT, OutputT> getReducer() {
        return this.reducer;
    }

    public boolean isCombinable() {
        return this.reducer.isCombinable();
    }

    public UnaryFunction<InputT, ValueT> getValueExtractor() {
        return this.valueExtractor;
    }

    public Optional<BinaryFunction<ValueT, ValueT, Integer>> getValueComparator() {
        return Optional.ofNullable(this.valueComparator);
    }

    @Override
    public Optional<TypeDescriptor<ValueT>> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    @Override
    public PCollection<OutputT> expand(PCollectionList<InputT> inputs) {
        ReduceByKey.ReduceByBuilder reduceBy = ReduceByKey.named(this.getName().orElse("") + "::reduce-by").of((PCollection)PCollectionLists.getOnlyElement(inputs)).keyBy(e -> B_ZERO).valueBy(this.valueExtractor, this.valueType);
        ReduceByKey.WithSortedValuesBuilder sortBy = reduceBy.reduceBy(this.reducer);
        if (this.isCombinable()) {
            Preconditions.checkState((this.valueComparator == null ? 1 : 0) != 0, (Object)"Sorting is not supported for combinable reducers.");
        }
        ReduceByKey.WithSortedValuesBuilder windowBy = this.getValueComparator().isPresent() ? sortBy.withSortedValues(this.getValueComparator().get()) : sortBy;
        return windowBy.applyIf(this.getWindow().isPresent(), builder -> {
            ReduceByKey.WindowByInternalBuilder casted = (ReduceByKey.WindowByInternalBuilder)((Object)builder);
            return casted.windowBy(this.getWindow().orElseThrow(() -> new IllegalStateException("Unable to resolve windowing for ReduceWindow expansion.")));
        }).outputValues(new OutputHint[0]);
    }

    private static class Builder<InputT, ValueT, OutputT>
    implements OfBuilder,
    ValueByReduceByBuilder<InputT, ValueT>,
    WithSortedValuesBuilder<ValueT, OutputT>,
    WindowByBuilder<OutputT>,
    TriggeredByBuilder<OutputT>,
    AccumulationModeBuilder<OutputT>,
    WindowedOutputBuilder<OutputT>,
    Builders.Output<OutputT> {
        private final WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        @Nullable
        private final String name;
        private PCollection<InputT> input;
        @Nullable
        private UnaryFunction<InputT, ValueT> valueExtractor;
        @Nullable
        private TypeDescriptor<ValueT> valueType;
        private ReduceFunctor<ValueT, OutputT> reducer;
        @Nullable
        private TypeDescriptor<OutputT> outputType;
        @Nullable
        private BinaryFunction<ValueT, ValueT, Integer> valueComparator;

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> ValueByReduceByBuilder<T, T> of(PCollection<T> input) {
            Builder casted = this;
            casted.input = Objects.requireNonNull(input);
            return casted;
        }

        @Override
        public <T> ReduceByBuilder<T> valueBy(UnaryFunction<InputT, T> valueExtractor, @Nullable TypeDescriptor<T> valueType) {
            Builder casted = this;
            casted.valueExtractor = Objects.requireNonNull(valueExtractor);
            casted.valueType = valueType;
            return casted;
        }

        @Override
        public <T> WithSortedValuesBuilder<ValueT, T> reduceBy(ReduceFunctor<ValueT, T> reducer, @Nullable TypeDescriptor<T> outputType) {
            if (this.valueExtractor == null) {
                this.valueExtractor = UnaryFunction.identity();
            }
            Builder casted = this;
            casted.reducer = Objects.requireNonNull(reducer);
            casted.outputType = outputType;
            return casted;
        }

        @Override
        public WindowByBuilder<OutputT> withSortedValues(BinaryFunction<ValueT, ValueT, Integer> valueComparator) {
            this.valueComparator = Objects.requireNonNull(valueComparator);
            return this;
        }

        @Override
        public <T extends BoundedWindow> TriggeredByBuilder<OutputT> windowBy(WindowFn<Object, T> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public AccumulationModeBuilder<OutputT> triggeredBy(Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withAllowedLateness(Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withTimestampCombiner(TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public PCollection<OutputT> output(OutputHint ... outputHints) {
            ReduceWindow rw = new ReduceWindow(this.name, this.valueExtractor, this.valueType, this.reducer, this.valueComparator, this.windowBuilder.getWindow().orElse(null), this.outputType);
            return OperatorTransform.apply(rw, PCollectionList.of(this.input));
        }
    }

    public static interface WindowedOutputBuilder<OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<OutputT>>,
    Builders.Output<OutputT> {
    }

    public static interface AccumulationModeBuilder<OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<OutputT>> {
        @Override
        public WindowedOutputBuilder<OutputT> accumulationMode(WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<OutputT>> {
        @Override
        public AccumulationModeBuilder<OutputT> triggeredBy(Trigger var1);
    }

    public static interface WindowByBuilder<OutputT>
    extends Builders.WindowBy<TriggeredByBuilder<OutputT>>,
    OptionalMethodBuilder<WindowByBuilder<OutputT>, Builders.Output<OutputT>>,
    Builders.Output<OutputT> {
        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<OutputT> windowBy(WindowFn<Object, W> var1);

        @Override
        default public Builders.Output<OutputT> applyIf(boolean cond, UnaryFunction<WindowByBuilder<OutputT>, Builders.Output<OutputT>> fn) {
            Objects.requireNonNull(fn);
            return cond ? fn.apply(this) : this;
        }
    }

    public static interface WithSortedValuesBuilder<ValueT, OutputT>
    extends WindowByBuilder<OutputT> {
        public WindowByBuilder<OutputT> withSortedValues(BinaryFunction<ValueT, ValueT, Integer> var1);
    }

    public static interface ValueByReduceByBuilder<InputT, ValueT>
    extends ReduceByBuilder<ValueT> {
        public <T> ReduceByBuilder<T> valueBy(UnaryFunction<InputT, T> var1, @Nullable TypeDescriptor<T> var2);

        default public <T> ReduceByBuilder<T> valueBy(UnaryFunction<InputT, T> valueExtractor) {
            return this.valueBy(valueExtractor, null);
        }
    }

    public static interface ReduceByBuilder<ValueT> {
        default public <OutputT> WithSortedValuesBuilder<ValueT, OutputT> reduceBy(ReduceFunction<ValueT, OutputT> reducer) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)));
        }

        default public <OutputT> WithSortedValuesBuilder<ValueT, OutputT> reduceBy(ReduceFunction<ValueT, OutputT> reducer, TypeDescriptor<OutputT> outputType) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)), outputType);
        }

        default public <OutputT> WithSortedValuesBuilder<ValueT, OutputT> reduceBy(ReduceFunctor<ValueT, OutputT> reducer) {
            return this.reduceBy(reducer, null);
        }

        public <OutputT> WithSortedValuesBuilder<ValueT, OutputT> reduceBy(ReduceFunctor<ValueT, OutputT> var1, @Nullable TypeDescriptor<OutputT> var2);

        default public WindowByBuilder<ValueT> combineBy(CombinableReduceFunction<ValueT> reducer) {
            return this.reduceBy(ReduceFunctor.of(reducer));
        }

        default public WindowByBuilder<ValueT> combineBy(CombinableReduceFunction<ValueT> reducer, TypeDescriptor<ValueT> outputType) {
            return this.reduceBy(ReduceFunctor.of(reducer), outputType);
        }
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> ValueByReduceByBuilder<InputT, InputT> of(PCollection<InputT> var1);
    }
}

