/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Recommended;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.OutputValues;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;

@Recommended(reason="Is very recommended to override because of performance in a specific area of (mostly) batch calculations where combiners can be efficiently used in the executor-specific implementation", state=StateComplexity.CONSTANT_IF_COMBINABLE, repartitions=1)
public class ReduceByKey<InputT, KeyT, ValueT, OutputT>
extends ShuffleOperator<InputT, KeyT, KV<KeyT, OutputT>>
implements TypeAware.Value<ValueT> {
    private final ReduceFunctor<ValueT, OutputT> reducer;
    private final UnaryFunction<InputT, ValueT> valueExtractor;
    @Nullable
    private final BinaryFunction<ValueT, ValueT, Integer> valueComparator;
    @Nullable
    private final TypeDescriptor<ValueT> valueType;

    public static <InputT> KeyByBuilder<InputT> of(PCollection<InputT> input) {
        return ReduceByKey.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private ReduceByKey(@Nullable String name, UnaryFunction<InputT, KeyT> keyExtractor, @Nullable TypeDescriptor<KeyT> keyType, UnaryFunction<InputT, ValueT> valueExtractor, @Nullable TypeDescriptor<ValueT> valueType, ReduceFunctor<ValueT, OutputT> reducer, @Nullable BinaryFunction<ValueT, ValueT, Integer> valueComparator, @Nullable Window<InputT> window, TypeDescriptor<KV<KeyT, OutputT>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
        this.reducer = reducer;
        this.valueExtractor = valueExtractor;
        this.valueType = valueType;
        this.valueComparator = valueComparator;
    }

    public ReduceFunctor<ValueT, OutputT> getReducer() {
        return this.reducer;
    }

    public boolean isCombinable() {
        return this.reducer.isCombinable();
    }

    public UnaryFunction<InputT, ValueT> getValueExtractor() {
        return this.valueExtractor;
    }

    public Optional<BinaryFunction<ValueT, ValueT, Integer>> getValueComparator() {
        return Optional.ofNullable(this.valueComparator);
    }

    @Override
    public Optional<TypeDescriptor<ValueT>> getValueType() {
        return Optional.ofNullable(this.valueType);
    }

    static class Builder<InputT, KeyT, ValueT, OutputT>
    implements OfBuilder,
    KeyByBuilder<InputT>,
    ValueByReduceByBuilder<InputT, KeyT, ValueT>,
    WithSortedValuesBuilder<KeyT, ValueT, OutputT>,
    WindowByInternalBuilder<InputT, KeyT, OutputT>,
    WindowByBuilder<KeyT, OutputT>,
    TriggeredByBuilder<KeyT, OutputT>,
    AccumulationModeBuilder<KeyT, OutputT>,
    WindowedOutputBuilder<KeyT, OutputT>,
    OutputBuilder<KeyT, OutputT> {
        private final WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        @Nullable
        private final String name;
        private PCollection<InputT> input;
        private UnaryFunction<InputT, KeyT> keyExtractor;
        @Nullable
        private TypeDescriptor<KeyT> keyType;
        @Nullable
        private UnaryFunction<InputT, ValueT> valueExtractor;
        @Nullable
        private TypeDescriptor<ValueT> valueType;
        private ReduceFunctor<ValueT, OutputT> reducer;
        @Nullable
        private TypeDescriptor<OutputT> outputType;
        @Nullable
        private BinaryFunction<ValueT, ValueT, Integer> valueComparator;

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> KeyByBuilder<T> of(PCollection<T> input) {
            Builder casted = this;
            casted.input = input;
            return casted;
        }

        @Override
        public <T> ValueByReduceByBuilder<InputT, T, InputT> keyBy(UnaryFunction<InputT, T> keyExtractor, @Nullable TypeDescriptor<T> keyType) {
            Builder casted = this;
            casted.keyExtractor = Objects.requireNonNull(keyExtractor);
            casted.keyType = keyType;
            return casted;
        }

        @Override
        public <T> ReduceByBuilder<KeyT, T> valueBy(UnaryFunction<InputT, T> valueExtractor, @Nullable TypeDescriptor<T> valueType) {
            Builder casted = this;
            casted.valueExtractor = Objects.requireNonNull(valueExtractor);
            casted.valueType = valueType;
            return casted;
        }

        @Override
        public <T> WithSortedValuesBuilder<KeyT, ValueT, T> reduceBy(ReduceFunctor<ValueT, T> reducer, @Nullable TypeDescriptor<T> outputType) {
            if (this.valueExtractor == null) {
                this.valueExtractor = UnaryFunction.identity();
            }
            Builder casted = this;
            casted.reducer = Objects.requireNonNull(reducer);
            casted.outputType = outputType;
            return casted;
        }

        @Override
        public WindowByBuilder<KeyT, OutputT> withSortedValues(BinaryFunction<ValueT, ValueT, Integer> valueComparator) {
            this.valueComparator = Objects.requireNonNull(valueComparator);
            return this;
        }

        @Override
        public OutputBuilder<KeyT, OutputT> windowBy(Window<InputT> window) {
            this.windowBuilder.setWindow(window);
            return this;
        }

        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT, OutputT> windowBy(WindowFn<Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public AccumulationModeBuilder<KeyT, OutputT> triggeredBy(Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withTimestampCombiner(TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT, OutputT> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public PCollection<KV<KeyT, OutputT>> output(OutputHint ... outputHints) {
            return OperatorTransform.apply(this.createOperator(), PCollectionList.of(this.input));
        }

        @Override
        public PCollection<OutputT> outputValues(OutputHint ... outputHints) {
            return OperatorTransform.apply(new OutputValues(this.name, this.outputType, this.createOperator()), PCollectionList.of(this.input));
        }

        private ReduceByKey<InputT, KeyT, ValueT, OutputT> createOperator() {
            return new ReduceByKey(this.name, this.keyExtractor, this.keyType, this.valueExtractor, this.valueType, this.reducer, this.valueComparator, this.windowBuilder.getWindow().orElse(null), TypeDescriptors.kvs(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeAwareness.orObjects(Optional.ofNullable(this.outputType))));
        }
    }

    public static interface OutputBuilder<KeyT, OutputT>
    extends Builders.Output<KV<KeyT, OutputT>>,
    Builders.OutputValues<KeyT, OutputT> {
    }

    public static interface WindowedOutputBuilder<KeyT, OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
    }

    public static interface AccumulationModeBuilder<KeyT, OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT, OutputT>> {
        @Override
        public WindowedOutputBuilder<KeyT, OutputT> accumulationMode(WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<KeyT, OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT, OutputT>> {
        @Override
        public AccumulationModeBuilder<KeyT, OutputT> triggeredBy(Trigger var1);
    }

    public static interface WindowByBuilder<KeyT, OutputT>
    extends Builders.WindowBy<TriggeredByBuilder<KeyT, OutputT>>,
    OptionalMethodBuilder<WindowByBuilder<KeyT, OutputT>, OutputBuilder<KeyT, OutputT>>,
    OutputBuilder<KeyT, OutputT> {
        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT, OutputT> windowBy(WindowFn<Object, W> var1);

        @Override
        default public OutputBuilder<KeyT, OutputT> applyIf(boolean cond, UnaryFunction<WindowByBuilder<KeyT, OutputT>, OutputBuilder<KeyT, OutputT>> fn) {
            Objects.requireNonNull(fn);
            return cond ? fn.apply(this) : this;
        }
    }

    @Internal
    public static interface WindowByInternalBuilder<InputT, KeyT, OutputT> {
        public OutputBuilder<KeyT, OutputT> windowBy(Window<InputT> var1);
    }

    public static interface WithSortedValuesBuilder<KeyT, ValueT, OutputT>
    extends WindowByBuilder<KeyT, OutputT> {
        public WindowByBuilder<KeyT, OutputT> withSortedValues(BinaryFunction<ValueT, ValueT, Integer> var1);
    }

    public static interface ValueByReduceByBuilder<InputT, KeyT, ValueT>
    extends ReduceByBuilder<KeyT, ValueT> {
        public <T> ReduceByBuilder<KeyT, T> valueBy(UnaryFunction<InputT, T> var1, @Nullable TypeDescriptor<T> var2);

        default public <T> ReduceByBuilder<KeyT, T> valueBy(UnaryFunction<InputT, T> valueExtractor) {
            return this.valueBy(valueExtractor, null);
        }
    }

    public static interface ReduceByBuilder<KeyT, ValueT> {
        default public <OutputT> WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(ReduceFunction<ValueT, OutputT> reducer) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)));
        }

        default public <OutputT> WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(ReduceFunction<ValueT, OutputT> reducer, TypeDescriptor<OutputT> outputType) {
            return this.reduceBy((in, ctx) -> ctx.collect(reducer.apply(in)), outputType);
        }

        default public <OutputT> WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(ReduceFunctor<ValueT, OutputT> reducer) {
            return this.reduceBy(reducer, null);
        }

        public <OutputT> WithSortedValuesBuilder<KeyT, ValueT, OutputT> reduceBy(ReduceFunctor<ValueT, OutputT> var1, @Nullable TypeDescriptor<OutputT> var2);

        default public WindowByBuilder<KeyT, ValueT> combineBy(CombinableReduceFunction<ValueT> reducer) {
            return this.reduceBy(ReduceFunctor.of(reducer));
        }

        default public WindowByBuilder<KeyT, ValueT> combineBy(CombinableReduceFunction<ValueT> reducer, TypeDescriptor<ValueT> outputType) {
            return this.reduceBy(ReduceFunctor.of(reducer), outputType);
        }
    }

    public static interface KeyByBuilder<InputT>
    extends Builders.KeyBy<InputT> {
        public <T> ValueByReduceByBuilder<InputT, T, InputT> keyBy(UnaryFunction<InputT, T> var1, TypeDescriptor<T> var2);

        default public <T> ValueByReduceByBuilder<InputT, T, InputT> keyBy(UnaryFunction<InputT, T> keyExtractor) {
            return this.keyBy((UnaryFunction)keyExtractor, (TypeDescriptor)null);
        }
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> KeyByBuilder<InputT> of(PCollection<InputT> var1);
    }
}

