/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.MapElements;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;

@Internal
class OutputValues<InputT, KeyT, OutputT>
extends Operator<OutputT>
implements CompositeOperator<InputT, OutputT> {
    private final Operator<KV<KeyT, OutputT>> keyedOperator;

    OutputValues(@Nullable String name, @Nullable TypeDescriptor<OutputT> outputType, Operator<KV<KeyT, OutputT>> keyedOperator) {
        super(name, outputType);
        this.keyedOperator = keyedOperator;
    }

    @Override
    public PCollection<OutputT> expand(PCollectionList<InputT> inputs) {
        PCollection keyedOutput = OperatorTransform.apply(this.keyedOperator, inputs);
        return MapElements.named("ExtractValues").of(keyedOutput).using(KV::getValue, (TypeDescriptor)this.getOutputType().orElse(null)).output(new OutputHint[0]);
    }
}

