/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunctionEnv;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Context;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class MapElements<InputT, OutputT>
extends Operator<OutputT>
implements CompositeOperator<InputT, OutputT>,
TypeAware.Output<OutputT> {
    private final UnaryFunctionEnv<InputT, OutputT> mapper;

    public static <InputT> UsingBuilder<InputT> of(PCollection<InputT> input) {
        return MapElements.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private MapElements(@Nullable String name, UnaryFunctionEnv<InputT, OutputT> mapper, @Nullable TypeDescriptor<OutputT> outputType) {
        super(name, outputType);
        this.mapper = mapper;
    }

    @Override
    public PCollection<OutputT> expand(PCollectionList<InputT> inputs) {
        return FlatMap.named(this.getName().orElse(null)).of((PCollection)PCollectionLists.getOnlyElement(inputs)).using((elem, coll) -> coll.collect(this.getMapper().apply(elem, coll.asContext())), this.getOutputType().orElse(null)).output(new OutputHint[0]);
    }

    public UnaryFunctionEnv<InputT, OutputT> getMapper() {
        return this.mapper;
    }

    private static class Builder<InputT, OutputT>
    implements OfBuilder,
    UsingBuilder<InputT>,
    Builders.Output<OutputT> {
        @Nullable
        private final String name;
        private PCollection<InputT> input;
        private UnaryFunctionEnv<InputT, OutputT> mapper;
        @Nullable
        private TypeDescriptor<OutputT> outputType;

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> UsingBuilder<T> of(PCollection<T> input) {
            Builder casted = this;
            casted.input = input;
            return casted;
        }

        @Override
        public <T> Builders.Output<T> using(UnaryFunctionEnv<InputT, T> mapper, @Nullable TypeDescriptor<T> outputType) {
            Builder casted = this;
            casted.mapper = mapper;
            casted.outputType = outputType;
            return casted;
        }

        @Override
        public PCollection<OutputT> output(OutputHint ... outputHints) {
            MapElements operator = new MapElements(this.name, this.mapper, this.outputType);
            return OperatorTransform.apply(operator, PCollectionList.of(this.input));
        }
    }

    public static interface UsingBuilder<InputT> {
        default public <OutputT> Builders.Output<OutputT> using(UnaryFunction<InputT, OutputT> mapper) {
            return this.using(mapper, null);
        }

        default public <OutputT> Builders.Output<OutputT> using(UnaryFunction<InputT, OutputT> mapper, @Nullable TypeDescriptor<OutputT> outputType) {
            return this.using((InputT el, Context ctx) -> mapper.apply(el), outputType);
        }

        default public <OutputT> Builders.Output<OutputT> using(UnaryFunctionEnv<InputT, OutputT> mapper) {
            return this.using(mapper, null);
        }

        public <OutputT> Builders.Output<OutputT> using(UnaryFunctionEnv<InputT, OutputT> var1, @Nullable TypeDescriptor<OutputT> var2);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> UsingBuilder<InputT> of(PCollection<InputT> var1);
    }
}

