/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Collector;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Join;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;

public class LeftJoin {
    public static <LeftT, RightT> ByBuilder<LeftT, RightT> of(PCollection<LeftT> left, PCollection<RightT> right) {
        return LeftJoin.named("LeftJoin").of(left, right);
    }

    public static OfBuilder named(String name) {
        return new Builder(name);
    }

    private static class Builder<LeftT, RightT, KeyT>
    implements OfBuilder,
    ByBuilder<LeftT, RightT>,
    UsingBuilder<LeftT, RightT, KeyT> {
        private final String name;
        private PCollection<LeftT> left;
        private PCollection<RightT> right;
        private UnaryFunction<LeftT, KeyT> leftKeyExtractor;
        private UnaryFunction<RightT, KeyT> rightKeyExtractor;
        @Nullable
        TypeDescriptor<KeyT> keyType;

        private Builder(String name) {
            this.name = name;
        }

        public <FirstT, SecondT> ByBuilder<FirstT, SecondT> of(PCollection<FirstT> left, PCollection<SecondT> right) {
            Builder casted = this;
            casted.left = Objects.requireNonNull(left);
            casted.right = Objects.requireNonNull(right);
            return casted;
        }

        @Override
        public <T> UsingBuilder<LeftT, RightT, T> by(UnaryFunction<LeftT, T> leftKeyExtractor, UnaryFunction<RightT, T> rightKeyExtractor, @Nullable TypeDescriptor<T> keyType) {
            Builder casted = this;
            casted.leftKeyExtractor = Objects.requireNonNull(leftKeyExtractor);
            casted.rightKeyExtractor = Objects.requireNonNull(rightKeyExtractor);
            casted.keyType = keyType;
            return casted;
        }

        @Override
        public <OutputT> Join.WindowByBuilder<KeyT, OutputT> using(BinaryFunctor<LeftT, Optional<RightT>, OutputT> joinFunc, @Nullable TypeDescriptor<OutputT> outputType) {
            return new Join.Builder(this.name, Join.Type.LEFT).of(this.left, this.right).by(this.leftKeyExtractor, this.rightKeyExtractor, this.keyType).using((LeftT l, RightT r, Collector<OutputT> c) -> joinFunc.apply(l, Optional.ofNullable(r), c), outputType);
        }
    }

    public static interface UsingBuilder<LeftT, RightT, KeyT> {
        public <OutputT> Join.WindowByBuilder<KeyT, OutputT> using(BinaryFunctor<LeftT, Optional<RightT>, OutputT> var1, @Nullable TypeDescriptor<OutputT> var2);

        default public <OutputT> Join.WindowByBuilder<KeyT, OutputT> using(BinaryFunctor<LeftT, Optional<RightT>, OutputT> joinFunc) {
            return this.using(joinFunc, null);
        }
    }

    public static interface ByBuilder<LeftT, RightT> {
        public <KeyT> UsingBuilder<LeftT, RightT, KeyT> by(UnaryFunction<LeftT, KeyT> var1, UnaryFunction<RightT, KeyT> var2, @Nullable TypeDescriptor<KeyT> var3);

        default public <KeyT> UsingBuilder<LeftT, RightT, KeyT> by(UnaryFunction<LeftT, KeyT> leftKeyExtractor, UnaryFunction<RightT, KeyT> rightKeyExtractor) {
            return this.by(leftKeyExtractor, rightKeyExtractor, null);
        }
    }

    public static interface OfBuilder {
        public <LeftT, RightT> ByBuilder<LeftT, RightT> of(PCollection<LeftT> var1, PCollection<RightT> var2);
    }
}

