/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Basic;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ExtractEventTime;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAware;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;

@Basic(state=StateComplexity.ZERO, repartitions=0)
public class FlatMap<InputT, OutputT>
extends Operator<OutputT>
implements TypeAware.Output<OutputT> {
    private final UnaryFunctor<InputT, OutputT> functor;
    @Nullable
    private final ExtractEventTime<InputT> eventTimeFn;

    public static <InputT> UsingBuilder<InputT> of(PCollection<InputT> input) {
        return FlatMap.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private FlatMap(@Nullable String name, UnaryFunctor<InputT, OutputT> functor, @Nullable TypeDescriptor<OutputT> outputType, @Nullable ExtractEventTime<InputT> evtTimeFn) {
        super(name, outputType);
        this.functor = functor;
        this.eventTimeFn = evtTimeFn;
    }

    public UnaryFunctor<InputT, OutputT> getFunctor() {
        return this.functor;
    }

    public Optional<ExtractEventTime<InputT>> getEventTimeExtractor() {
        return Optional.ofNullable(this.eventTimeFn);
    }

    public static class Builder<InputT, OutputT>
    implements OfBuilder,
    UsingBuilder<InputT>,
    EventTimeBuilder<InputT, OutputT>,
    Builders.Output<OutputT> {
        @Nullable
        private final String name;
        private PCollection<InputT> input;
        private UnaryFunctor<InputT, OutputT> functor;
        @Nullable
        private TypeDescriptor<OutputT> outputType;
        @Nullable
        private ExtractEventTime<InputT> evtTimeFn;

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <InputLocalT> UsingBuilder<InputLocalT> of(PCollection<InputLocalT> input) {
            Builder casted = this;
            casted.input = Objects.requireNonNull(input);
            return casted;
        }

        @Override
        public <OutputLocalT> EventTimeBuilder<InputT, OutputLocalT> using(UnaryFunctor<InputT, OutputLocalT> functor) {
            return this.using(functor, (TypeDescriptor<OutputLocalT>)null);
        }

        @Override
        public <OutputLocalT> EventTimeBuilder<InputT, OutputLocalT> using(UnaryFunctor<InputT, OutputLocalT> functor, TypeDescriptor<OutputLocalT> outputType) {
            Builder casted = this;
            casted.functor = Objects.requireNonNull(functor);
            casted.outputType = outputType;
            return casted;
        }

        @Override
        public Builders.Output<OutputT> eventTimeBy(ExtractEventTime<InputT> eventTimeFn) {
            this.evtTimeFn = Objects.requireNonNull(eventTimeFn);
            return this;
        }

        @Override
        public PCollection<OutputT> output(OutputHint ... outputHints) {
            return OperatorTransform.apply(new FlatMap(this.name, this.functor, this.outputType, this.evtTimeFn), PCollectionList.of(this.input));
        }
    }

    public static interface EventTimeBuilder<InputT, OutputT>
    extends Builders.Output<OutputT> {
        public Builders.Output<OutputT> eventTimeBy(ExtractEventTime<InputT> var1);
    }

    public static interface UsingBuilder<InputT> {
        public <OutputT> EventTimeBuilder<InputT, OutputT> using(UnaryFunctor<InputT, OutputT> var1);

        public <OutputT> EventTimeBuilder<InputT, OutputT> using(UnaryFunctor<InputT, OutputT> var1, TypeDescriptor<OutputT> var2);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> UsingBuilder<InputT> of(PCollection<InputT> var1);
    }
}

