/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryPredicate;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class Filter<InputT>
extends Operator<InputT>
implements CompositeOperator<InputT, InputT> {
    private final UnaryPredicate<InputT> predicate;

    public static <InputT> ByBuilder<InputT> of(PCollection<InputT> input) {
        return Filter.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private Filter(@Nullable String name, UnaryPredicate<InputT> predicate, @Nullable TypeDescriptor<InputT> outputType) {
        super(name, outputType);
        this.predicate = predicate;
    }

    public UnaryPredicate<InputT> getPredicate() {
        return this.predicate;
    }

    @Override
    public PCollection<InputT> expand(PCollectionList<InputT> inputs) {
        return FlatMap.named(this.getName().orElse(null)).of((PCollection)PCollectionLists.getOnlyElement(inputs)).using((element, collector) -> {
            if (((Boolean)this.getPredicate().apply(element)).booleanValue()) {
                collector.collect(element);
            }
        }, this.getOutputType().orElse(null)).output(new OutputHint[0]);
    }

    private static class Builder<InputT>
    implements OfBuilder,
    ByBuilder<InputT>,
    Builders.Output<InputT> {
        @Nullable
        private final String name;
        private PCollection<InputT> input;
        private UnaryPredicate<InputT> predicate;

        private Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> ByBuilder<T> of(PCollection<T> input) {
            Builder casted = this;
            casted.input = Objects.requireNonNull(input);
            return casted;
        }

        @Override
        public Builders.Output<InputT> by(UnaryPredicate<InputT> predicate) {
            this.predicate = Objects.requireNonNull(predicate);
            return this;
        }

        @Override
        public PCollection<InputT> output(OutputHint ... outputHints) {
            Filter filter = new Filter(this.name, this.predicate, this.input.getTypeDescriptor());
            return OperatorTransform.apply(filter, PCollectionList.of(this.input));
        }
    }

    public static interface ByBuilder<InputT> {
        public Builders.Output<InputT> by(UnaryPredicate<InputT> var1);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> ByBuilder<InputT> of(PCollection<InputT> var1);
    }
}

