/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Recommended;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.MapElements;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;

@Recommended(reason="Might be useful to override the default implementation because of performance reasons(e.g. using bloom filters), which might reduce the space complexity", state=StateComplexity.CONSTANT, repartitions=1)
public class Distinct<InputT, OutputT>
extends ShuffleOperator<InputT, OutputT, OutputT>
implements CompositeOperator<InputT, OutputT> {
    public static <InputT> MappedBuilder<InputT, InputT> of(PCollection<InputT> input) {
        return Distinct.named(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private Distinct(@Nullable String name, UnaryFunction<InputT, OutputT> mapper, @Nullable TypeDescriptor<OutputT> outputType, @Nullable Window<InputT> window) {
        super(name, outputType, mapper, outputType, window);
    }

    @Override
    public PCollection<OutputT> expand(PCollectionList<InputT> inputs) {
        PCollection distinct = ReduceByKey.named(this.getName().orElse(null)).of((PCollection)PCollectionLists.getOnlyElement(inputs)).keyBy(this.getKeyExtractor()).valueBy(e -> null, TypeDescriptors.nulls()).combineBy(e -> null).applyIf(this.getWindow().isPresent(), builder -> {
            ReduceByKey.WindowByInternalBuilder casted = (ReduceByKey.WindowByInternalBuilder)((Object)builder);
            return casted.windowBy(this.getWindow().orElseThrow(() -> new IllegalStateException("Unable to resolve windowing for Distinct expansion.")));
        }).output(new OutputHint[0]);
        return MapElements.named(this.getName().orElse("") + "::extract-keys").of(distinct).using(KV::getKey, (TypeDescriptor)this.getKeyType().orElse(null)).output(new OutputHint[0]);
    }

    private static class Builder<InputT, OutputT>
    implements OfBuilder,
    MappedBuilder<InputT, OutputT>,
    WindowByBuilder<OutputT>,
    TriggerByBuilder<OutputT>,
    AccumulationModeBuilder<OutputT>,
    WindowedOutputBuilder<OutputT>,
    Builders.Output<OutputT> {
        private final WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        @Nullable
        private final String name;
        private PCollection<InputT> input;
        @Nullable
        private UnaryFunction<InputT, OutputT> mapper;
        @Nullable
        private TypeDescriptor<OutputT> outputType;

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> MappedBuilder<T, T> of(PCollection<T> input) {
            Builder casted = this;
            casted.input = Objects.requireNonNull(input);
            return casted;
        }

        @Override
        public <T> WindowByBuilder<T> mapped(UnaryFunction<InputT, T> mapper, @Nullable TypeDescriptor<T> outputType) {
            Builder casted = this;
            casted.mapper = Objects.requireNonNull(mapper);
            casted.outputType = outputType;
            return casted;
        }

        @Override
        public <T extends BoundedWindow> TriggerByBuilder<OutputT> windowBy(WindowFn<Object, T> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public AccumulationModeBuilder<OutputT> triggeredBy(Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withAllowedLateness(Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withTimestampCombiner(TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public WindowedOutputBuilder<OutputT> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public PCollection<OutputT> output(OutputHint ... outputHints) {
            if (this.mapper == null) {
                this.mapper = UnaryFunction.identity();
            }
            Distinct distinct = new Distinct(this.name, this.mapper, this.outputType, this.windowBuilder.getWindow().orElse(null));
            return OperatorTransform.apply(distinct, PCollectionList.of(this.input));
        }
    }

    public static interface WindowedOutputBuilder<OutputT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<OutputT>>,
    Builders.Output<OutputT> {
    }

    public static interface AccumulationModeBuilder<OutputT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<OutputT>> {
        @Override
        public WindowedOutputBuilder<OutputT> accumulationMode(WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggerByBuilder<OutputT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<OutputT>> {
        @Override
        public AccumulationModeBuilder<OutputT> triggeredBy(Trigger var1);
    }

    public static interface WindowByBuilder<OutputT>
    extends Builders.WindowBy<TriggerByBuilder<OutputT>>,
    OptionalMethodBuilder<WindowByBuilder<OutputT>, Builders.Output<OutputT>>,
    Builders.Output<OutputT> {
        @Override
        public <T extends BoundedWindow> TriggerByBuilder<OutputT> windowBy(WindowFn<Object, T> var1);

        @Override
        default public Builders.Output<OutputT> applyIf(boolean cond, UnaryFunction<WindowByBuilder<OutputT>, Builders.Output<OutputT>> fn) {
            return cond ? Objects.requireNonNull(fn).apply(this) : this;
        }
    }

    public static interface MappedBuilder<InputT, OutputT>
    extends WindowByBuilder<OutputT> {
        default public <T> WindowByBuilder<T> mapped(UnaryFunction<InputT, T> mapper) {
            return this.mapped(mapper, null);
        }

        public <T> WindowByBuilder<T> mapped(UnaryFunction<InputT, T> var1, @Nullable TypeDescriptor<T> var2);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> MappedBuilder<InputT, InputT> of(PCollection<InputT> var1);
    }
}

