/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.WindowBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.OptionalMethodBuilder;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.ShuffleOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeUtils;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.Sums;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;

@Derived(state=StateComplexity.CONSTANT, repartitions=1)
public class CountByKey<InputT, KeyT>
extends ShuffleOperator<InputT, KeyT, KV<KeyT, Long>>
implements CompositeOperator<InputT, KV<KeyT, Long>> {
    public static <InputT> KeyByBuilder<InputT> of(PCollection<InputT> input) {
        return new Builder(null).of((PCollection)input);
    }

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    private CountByKey(@Nullable String name, UnaryFunction<InputT, KeyT> keyExtractor, @Nullable TypeDescriptor<KeyT> keyType, @Nullable Window<InputT> window, TypeDescriptor<KV<KeyT, Long>> outputType) {
        super(name, outputType, keyExtractor, keyType, window);
    }

    @Override
    public PCollection<KV<KeyT, Long>> expand(PCollectionList<InputT> inputs) {
        return ReduceByKey.named(this.getName().orElse(null)).of((PCollection)PCollectionLists.getOnlyElement(inputs)).keyBy(this.getKeyExtractor(), (TypeDescriptor)this.getKeyType().orElse(null)).valueBy(v -> 1L, TypeDescriptors.longs()).combineBy(Sums.ofLongs(), (TypeDescriptor<Long>)TypeDescriptors.longs()).applyIf(this.getWindow().isPresent(), builder -> {
            ReduceByKey.WindowByInternalBuilder casted = (ReduceByKey.WindowByInternalBuilder)((Object)builder);
            return casted.windowBy(this.getWindow().orElseThrow(() -> new IllegalStateException("Unable to resolve windowing for CountByKey expansion.")));
        }).output(new OutputHint[0]);
    }

    private static class Builder<InputT, KeyT>
    implements OfBuilder,
    KeyByBuilder<InputT>,
    WindowByBuilder<KeyT>,
    TriggeredByBuilder<KeyT>,
    AccumulationModeBuilder<KeyT>,
    WindowedOutputBuilder<KeyT>,
    Builders.Output<KV<KeyT, Long>> {
        private final WindowBuilder<InputT> windowBuilder = new WindowBuilder();
        @Nullable
        private final String name;
        private PCollection<InputT> input;
        private UnaryFunction<InputT, KeyT> keyExtractor;
        @Nullable
        private TypeDescriptor<KeyT> keyType;

        Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> KeyByBuilder<T> of(PCollection<T> input) {
            this.input = Objects.requireNonNull(input);
            return this;
        }

        @Override
        public <T> WindowByBuilder<T> keyBy(UnaryFunction<InputT, T> keyExtractor, @Nullable TypeDescriptor<T> keyType) {
            Builder casted = this;
            casted.keyExtractor = Objects.requireNonNull(keyExtractor);
            casted.keyType = keyType;
            return casted;
        }

        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT> windowBy(WindowFn<Object, W> windowFn) {
            this.windowBuilder.windowBy((WindowFn)windowFn);
            return this;
        }

        @Override
        public AccumulationModeBuilder<KeyT> triggeredBy(Trigger trigger) {
            this.windowBuilder.triggeredBy(trigger);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT> accumulationMode(WindowingStrategy.AccumulationMode accumulationMode) {
            this.windowBuilder.accumulationMode(accumulationMode);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT> withAllowedLateness(Duration allowedLateness) {
            this.windowBuilder.withAllowedLateness(allowedLateness);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT> withAllowedLateness(Duration allowedLateness, Window.ClosingBehavior closingBehavior) {
            this.windowBuilder.withAllowedLateness(allowedLateness, closingBehavior);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT> withTimestampCombiner(TimestampCombiner timestampCombiner) {
            this.windowBuilder.withTimestampCombiner(timestampCombiner);
            return this;
        }

        @Override
        public WindowedOutputBuilder<KeyT> withOnTimeBehavior(Window.OnTimeBehavior behavior) {
            this.windowBuilder.withOnTimeBehavior(behavior);
            return this;
        }

        @Override
        public PCollection<KV<KeyT, Long>> output(OutputHint ... outputHints) {
            CountByKey cbk = new CountByKey(this.name, this.keyExtractor, this.keyType, this.windowBuilder.getWindow().orElse(null), TypeUtils.keyValues(TypeAwareness.orObjects(Optional.ofNullable(this.keyType)), TypeDescriptors.longs()));
            return OperatorTransform.apply(cbk, PCollectionList.of(this.input));
        }
    }

    public static interface WindowedOutputBuilder<KeyT>
    extends Builders.WindowedOutput<WindowedOutputBuilder<KeyT>>,
    Builders.Output<KV<KeyT, Long>> {
    }

    public static interface AccumulationModeBuilder<KeyT>
    extends Builders.AccumulationMode<WindowedOutputBuilder<KeyT>> {
        @Override
        public WindowedOutputBuilder<KeyT> accumulationMode(WindowingStrategy.AccumulationMode var1);
    }

    public static interface TriggeredByBuilder<KeyT>
    extends Builders.TriggeredBy<AccumulationModeBuilder<KeyT>> {
        @Override
        public AccumulationModeBuilder<KeyT> triggeredBy(Trigger var1);
    }

    public static interface WindowByBuilder<KeyT>
    extends Builders.WindowBy<TriggeredByBuilder<KeyT>>,
    OptionalMethodBuilder<WindowByBuilder<KeyT>, Builders.Output<KV<KeyT, Long>>>,
    Builders.Output<KV<KeyT, Long>> {
        @Override
        public <W extends BoundedWindow> TriggeredByBuilder<KeyT> windowBy(WindowFn<Object, W> var1);

        @Override
        default public Builders.Output<KV<KeyT, Long>> applyIf(boolean cond, UnaryFunction<WindowByBuilder<KeyT>, Builders.Output<KV<KeyT, Long>>> fn) {
            return cond ? Objects.requireNonNull(fn).apply(this) : this;
        }
    }

    public static interface KeyByBuilder<InputT>
    extends Builders.KeyBy<InputT> {
        public <T> WindowByBuilder<T> keyBy(UnaryFunction<InputT, T> var1, TypeDescriptor<T> var2);

        default public <T> WindowByBuilder<T> keyBy(UnaryFunction<InputT, T> keyExtractor) {
            return this.keyBy((UnaryFunction)keyExtractor, (TypeDescriptor)null);
        }
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> KeyByBuilder<InputT> of(PCollection<InputT> var1);
    }
}

