/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.operator;

import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ExtractEventTime;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Builders;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class AssignEventTime<InputT>
extends Operator<InputT>
implements CompositeOperator<InputT, InputT> {
    private final ExtractEventTime<InputT> eventTimeExtractor;

    public static OfBuilder named(@Nullable String name) {
        return new Builder(name);
    }

    public static <InputT> UsingBuilder<InputT> of(PCollection<InputT> input) {
        return AssignEventTime.named(null).of((PCollection)input);
    }

    private AssignEventTime(@Nullable String name, ExtractEventTime<InputT> eventTimeExtractor, @Nullable TypeDescriptor<InputT> outputType) {
        super(name, outputType);
        this.eventTimeExtractor = eventTimeExtractor;
    }

    public ExtractEventTime<InputT> getEventTimeExtractor() {
        return this.eventTimeExtractor;
    }

    @Override
    public PCollection<InputT> expand(PCollectionList<InputT> inputs) {
        PCollection<InputT> input = PCollectionLists.getOnlyElement(inputs);
        return FlatMap.named(this.getName().orElse(null)).of((PCollection)input).using((element, coll) -> coll.collect(element), input.getTypeDescriptor()).eventTimeBy(this.getEventTimeExtractor()).output(new OutputHint[0]);
    }

    public static class Builder<InputT>
    implements OfBuilder,
    UsingBuilder<InputT>,
    Builders.Output<InputT> {
        @Nullable
        private final String name;
        private PCollection<InputT> input;
        private ExtractEventTime<InputT> eventTimeExtractor;

        private Builder(@Nullable String name) {
            this.name = name;
        }

        public <T> UsingBuilder<T> of(PCollection<T> input) {
            Builder casted = this;
            casted.input = input;
            return casted;
        }

        @Override
        public Builders.Output<InputT> using(ExtractEventTime<InputT> eventTimeExtractor) {
            this.eventTimeExtractor = eventTimeExtractor;
            return this;
        }

        @Override
        public PCollection<InputT> output(OutputHint ... outputHints) {
            return OperatorTransform.apply(new AssignEventTime(this.name, this.eventTimeExtractor, this.input.getTypeDescriptor()), PCollectionList.of(this.input));
        }
    }

    public static interface UsingBuilder<InputT> {
        public Builders.Output<InputT> using(ExtractEventTime<InputT> var1);
    }

    public static interface OfBuilder
    extends Builders.Of {
        @Override
        public <InputT> UsingBuilder<InputT> of(PCollection<InputT> var1);
    }
}

