/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.lib;

import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.Derived;
import org.apache.beam.sdk.extensions.euphoria.core.annotation.operator.StateComplexity;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryPredicate;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Filter;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.values.PCollection;

@Derived(state=StateComplexity.ZERO, repartitions=0)
public class Split {
    static final String DEFAULT_NAME = "Split";
    static final String POSITIVE_FILTER_SUFFIX = "-positive";
    static final String NEGATIVE_FILTER_SUFFIX = "-negative";

    public static OfBuilder named(String name) {
        return new OfBuilder(name);
    }

    public static <InputT> UsingBuilder<InputT> of(PCollection<InputT> input) {
        return new UsingBuilder<InputT>(DEFAULT_NAME, input);
    }

    public static class Output<T> {
        private final PCollection<T> positive;
        private final PCollection<T> negative;

        private Output(PCollection<T> positive, PCollection<T> negative) {
            this.positive = Objects.requireNonNull(positive);
            this.negative = Objects.requireNonNull(negative);
        }

        public PCollection<T> positive() {
            return this.positive;
        }

        public PCollection<T> negative() {
            return this.negative;
        }
    }

    public static class OutputBuilder<InputT> {
        private final String name;
        private final PCollection<InputT> input;
        private final UnaryPredicate<InputT> predicate;

        OutputBuilder(String name, PCollection<InputT> input, UnaryPredicate<InputT> predicate) {
            this.name = Objects.requireNonNull(name);
            this.input = Objects.requireNonNull(input);
            this.predicate = Objects.requireNonNull(predicate);
        }

        public Output<InputT> output() {
            PCollection<InputT> positiveOutput = Filter.named(this.name + Split.POSITIVE_FILTER_SUFFIX).of((PCollection)this.input).by(this.predicate).output(new OutputHint[0]);
            PCollection negativeOutput = Filter.named(this.name + Split.NEGATIVE_FILTER_SUFFIX).of((PCollection)this.input).by(what -> (Boolean)this.predicate.apply(what) == false).output(new OutputHint[0]);
            return new Output(positiveOutput, negativeOutput);
        }
    }

    public static class UsingBuilder<InputT> {
        private final String name;
        private final PCollection<InputT> input;

        UsingBuilder(String name, PCollection<InputT> input) {
            this.name = Objects.requireNonNull(name);
            this.input = Objects.requireNonNull(input);
        }

        public OutputBuilder<InputT> using(UnaryPredicate<InputT> predicate) {
            return new OutputBuilder<InputT>(this.name, this.input, predicate);
        }
    }

    public static class OfBuilder {
        private final String name;

        OfBuilder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public <InputT> UsingBuilder<InputT> of(PCollection<InputT> input) {
            return new UsingBuilder<InputT>(this.name, input);
        }
    }
}

