/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.client.functional;

import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableReduceFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Collector;

@FunctionalInterface
public interface ReduceFunctor<InputT, OutputT>
extends UnaryFunctor<Stream<InputT>, OutputT> {
    public static <V> ReduceFunctor<V, V> of(final CombinableReduceFunction<V> combinableFunction) {
        return new ReduceFunctor<V, V>(){

            @Override
            public boolean isCombinable() {
                return true;
            }

            @Override
            public void apply(Stream<V> elem, Collector<V> context) {
                context.collect(combinableFunction.apply(elem));
            }
        };
    }

    default public boolean isCombinable() {
        return false;
    }
}

